% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Toeplitz.R
\name{Toeplitz}
\alias{Toeplitz}
\alias{is.Toeplitz}
\alias{as.Toeplitz}
\alias{ncol,Toeplitz-method}
\alias{nrow,Toeplitz-method}
\alias{dim.Toeplitz}
\alias{\%*\%}
\alias{determinant,Toeplitz-method}
\alias{determinant}
\alias{solve,Toeplitz-method}
\alias{solve}
\alias{solve,Toeplitz,ANY-method}
\title{Constructor and methods for Toeplitz matrix objects.}
\usage{
is.Toeplitz(x)

as.Toeplitz(x)

\method{dim}{Toeplitz}(x)
}
\arguments{
\item{x}{An R object.}
}
\description{
The \code{Toeplitz} class contains efficient methods for linear algebra with symmetric positive definite (i.e., variance) Toeplitz matrices.
}
\details{
An \verb{N x N} Toeplitz matrix \code{Tz} is defined by its length-\code{N} "autocorrelation" vector \code{acf}, i.e., first row/column \code{Tz}.  Thus, for the function \code{\link[stats:toeplitz]{stats::toeplitz()}}, we have \code{Tz = toeplitz(acf)}.

It is assumed that \code{acf} defines a valid (i.e., positive definite) variance matrix.  The matrix multiplication methods still work when this is not the case but the other methods do not (return values typically contain \code{NaN}s).

\code{as.Toeplitz(x)} attempts to convert its argument to a \code{Toeplitz} object by calling \code{Toeplitz$new(acf = x)}. \code{is.Toeplitz(x)} checks whether its argument is a \code{Toeplitz} object.
}
\examples{
# construct a Toeplitz matrix
acf <- exp(-(1:5))
Tz <- Toeplitz$new(acf = acf)
# alternatively, can allocate space first
Tz <- Toeplitz$new(N = length(acf))
Tz$set_acf(acf = acf)

# basic methods
Tz$get_acf() # extract the acf
dim(Tz) # == c(nrow(Tz), ncol(Tz))
Tz # print method

# linear algebra methods
X <- matrix(rnorm(10), 5, 2)
Tz \%*\% X
t(X) \%*\% Tz
solve(Tz, X)
determinant(Tz) # log-determinant
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Toeplitz-new}{\code{Toeplitz$new()}}
\item \href{#method-Toeplitz-print}{\code{Toeplitz$print()}}
\item \href{#method-Toeplitz-size}{\code{Toeplitz$size()}}
\item \href{#method-Toeplitz-set_acf}{\code{Toeplitz$set_acf()}}
\item \href{#method-Toeplitz-get_acf}{\code{Toeplitz$get_acf()}}
\item \href{#method-Toeplitz-has_acf}{\code{Toeplitz$has_acf()}}
\item \href{#method-Toeplitz-prod}{\code{Toeplitz$prod()}}
\item \href{#method-Toeplitz-solve}{\code{Toeplitz$solve()}}
\item \href{#method-Toeplitz-log_det}{\code{Toeplitz$log_det()}}
\item \href{#method-Toeplitz-trace_grad}{\code{Toeplitz$trace_grad()}}
\item \href{#method-Toeplitz-trace_hess}{\code{Toeplitz$trace_hess()}}
\item \href{#method-Toeplitz-clone}{\code{Toeplitz$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Toeplitz-new"></a>}}
\if{latex}{\out{\hypertarget{method-Toeplitz-new}{}}}
\subsection{Method \code{new()}}{
Class constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Toeplitz$new(N, acf)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{N}}{Size of Toeplitz matrix.}

\item{\code{acf}}{Autocorrelation vector of length \code{N}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Toeplitz} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Toeplitz-print"></a>}}
\if{latex}{\out{\hypertarget{method-Toeplitz-print}{}}}
\subsection{Method \code{print()}}{
Print method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Toeplitz$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Toeplitz-size"></a>}}
\if{latex}{\out{\hypertarget{method-Toeplitz-size}{}}}
\subsection{Method \code{size()}}{
Get the size of the Toeplitz matrix.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Toeplitz$size()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Size of the Toeplitz matrix.  \code{\link[base:nrow]{ncol()}}, \code{\link[base:nrow]{nrow()}}, and \code{\link[base:dim]{dim()}} methods for \code{Toeplitz} objects also work as expected.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Toeplitz-set_acf"></a>}}
\if{latex}{\out{\hypertarget{method-Toeplitz-set_acf}{}}}
\subsection{Method \code{set_acf()}}{
Set the autocorrelation of the Toeplitz matrix.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Toeplitz$set_acf(acf)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{acf}}{Autocorrelation vector of length \code{N}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Toeplitz-get_acf"></a>}}
\if{latex}{\out{\hypertarget{method-Toeplitz-get_acf}{}}}
\subsection{Method \code{get_acf()}}{
Get the autocorrelation of the Toeplitz matrix.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Toeplitz$get_acf()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The autocorrelation vector of length \code{N}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Toeplitz-has_acf"></a>}}
\if{latex}{\out{\hypertarget{method-Toeplitz-has_acf}{}}}
\subsection{Method \code{has_acf()}}{
Check whether the autocorrelation of the Toeplitz matrix has been set.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Toeplitz$has_acf()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Logical; \code{TRUE} if \code{Toeplitz$set_acf()} has been called.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Toeplitz-prod"></a>}}
\if{latex}{\out{\hypertarget{method-Toeplitz-prod}{}}}
\subsection{Method \code{prod()}}{
Toeplitz matrix-matrix product.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Toeplitz$prod(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Vector or matrix with \code{N} rows.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The matrix product \code{Tz \%*\% x}. \code{Tz \%*\% x} and \code{x \%*\% Tz} also work as expected.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Toeplitz-solve"></a>}}
\if{latex}{\out{\hypertarget{method-Toeplitz-solve}{}}}
\subsection{Method \code{solve()}}{
Solve a Toeplitz system of equations.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Toeplitz$solve(x, method = c("gschur", "pcg"), tol = 1e-10)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Optional vector or matrix with \code{N} rows.}

\item{\code{method}}{Solve method to use.  Choices are: \code{gschur} for a modified version of the Generalized Schur algorithm of Ammar & Gragg (1988), or \code{pcg} for the preconditioned conjugate gradient method of Chen et al (2006).  The former is faster and obtains the log-determinant as a direct biproduct.  The latter is more numerically stable for long-memory autocorrelations.}

\item{\code{tol}}{Tolerance level for the \code{pcg} method.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The solution in \code{z} to the system of equations \code{Tz \%*\% z = x}.  If \code{x} is missing, returns the inverse of \code{Tz}.  \code{solve(Tz, x)} and \code{solve(Tz, x, method, tol)} also work as expected.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Toeplitz-log_det"></a>}}
\if{latex}{\out{\hypertarget{method-Toeplitz-log_det}{}}}
\subsection{Method \code{log_det()}}{
Calculate the log-determinant of the Toeplitz matrix.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Toeplitz$log_det()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The log-determinant \code{log(det(Tz))}.  \code{determinant(Tz)} also works as expected.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Toeplitz-trace_grad"></a>}}
\if{latex}{\out{\hypertarget{method-Toeplitz-trace_grad}{}}}
\subsection{Method \code{trace_grad()}}{
Computes the trace-gradient with respect to Toeplitz matrices.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Toeplitz$trace_grad(acf2)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{acf2}}{Length-\code{N} autocorrelation vector of the second Toeplitz matrix.  This matrix must be symmetric but not necessarily positive definite.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Computes the trace of

\if{html}{\out{<div class="sourceCode">}}\preformatted{solve(Tz, toeplitz(acf2)).
}\if{html}{\out{</div>}}

This is used in the computation of the gradient of \code{log(det(Tz(theta)))} with respect to \code{theta}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Toeplitz-trace_hess"></a>}}
\if{latex}{\out{\hypertarget{method-Toeplitz-trace_hess}{}}}
\subsection{Method \code{trace_hess()}}{
Computes the trace-Hessian with respect to Toeplitz matrices.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Toeplitz$trace_hess(acf2, acf3)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{acf2}}{Length-\code{N} autocorrelation vector of the second Toeplitz matrix.  This matrix must be symmetric but not necessarily positive definite.}

\item{\code{acf3}}{Length-\code{N} autocorrelation vector of the third Toeplitz matrix.  This matrix must be symmetric but not necessarily positive definite.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Computes the trace of

\if{html}{\out{<div class="sourceCode">}}\preformatted{solve(Tz, toeplitz(acf2)) \%*\% solve(Tz, toeplitz(acf3)).
}\if{html}{\out{</div>}}

This is used in the computation of the Hessian of \code{log(det(Tz(theta)))} with respect to \code{theta}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Toeplitz-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Toeplitz-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Toeplitz$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
