% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{sm_preprocess_text}
\alias{sm_preprocess_text}
\title{Preprocess Text for Topic Modeling}
\usage{
sm_preprocess_text(
  data,
  text_col = "abstract",
  id_col = NULL,
  min_word_length = 3,
  custom_stopwords = NULL
)
}
\arguments{
\item{data}{A data.frame containing text data.}

\item{text_col}{Name of the column containing text to preprocess.
Default is "abstract".}

\item{id_col}{Name of the column containing document IDs. If NULL, a
doc_id column will be created. Default is NULL.}

\item{min_word_length}{Minimum word length to retain. Default is 3.}

\item{custom_stopwords}{Additional stopwords to remove beyond the standard
English stopwords. Default is NULL.}
}
\value{
A data.frame with columns: doc_id, stem, and n (word count).
}
\description{
Tokenizes, cleans, and stems text data in preparation for topic modeling.
Removes stopwords, numbers, and performs stemming using the Porter algorithm.
}
\examples{
\dontrun{
# Requires API data from sm_search_scopus()
papers <- sm_search_scopus(query, max_count = 50)
processed <- sm_preprocess_text(papers)
}
}
