% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{sk.create}
\alias{sk.create}
\title{generate split knockoff copies}
\usage{
sk.create(X, y, D, nu, option)
}
\arguments{
\item{X}{the design matrix}

\item{y}{the response vector}

\item{D}{the linear transform}

\item{nu}{the parameter for variable splitting}

\item{option}{options for creating the Knockoff copy
option$copy true : create a knockoff copy;}
}
\value{
A_beta: the design matrix for beta after variable splitting

A_gamma: the design matrix for gamma after variable splitting

tilde_y: the response vector after variable splitting.

tilde_A_gamma: the knockoff copy of A_beta; will be NULL if option$copy = false.
}
\description{
Gives the variable splitting design matrix
and response vector. It will also create a
split knockoff copy if required.
}
\examples{
option <- list()
option$q <- 0.2
option$method <- 'knockoff'
option$normalize <- 'true'
option$lambda <- 10.^seq(0, -6, by=-0.01)
option$nu <- 10
option$copy <- 'true'
library(mvtnorm)
sigma <-1
p <- 100
D <- diag(p)
m <- nrow(D)
n <- 350
nu = 10
c = 0.5
Sigma = matrix(0, p, p)
for( i in 1: p){
  for(j in 1: p){
    Sigma[i, j] <- c^(abs(i - j))
 }
}
X <- rmvnorm(n,matrix(0, p, 1), Sigma)
beta_true <- matrix(0, p, 1)
varepsilon <- rnorm(n) * sqrt(sigma)
y <- X \%*\% beta_true + varepsilon
creat.result  <- sk.create(X, y, D, nu, option)
A_beta  <- creat.result$A_beta
A_gamma <- creat.result$A_gamma
tilde_y <- creat.result$tilde_y
tilde_A_gamma <- creat.result$tilde_A_gamma
}
