% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_mu.R
\name{update_mu}
\alias{update_mu}
\title{Update the Center Values}
\usage{
update_mu(C_1, C_2, pdat1, pdat2, ncluster, lambda1, lambda2)
}
\arguments{
\item{C_1}{The cluster membership for samples in condition 1}

\item{C_2}{The cluster membership for samples in condition 2}

\item{pdat1}{The centered data from condition 1, columns should be
samples (cells) and rows should be features (genes).}

\item{pdat2}{The centered data from condition 2, columns should be
samples (cells) and rows should be features (genes). The number of genes
should be the same as \code{pdat1}.
as in pdat1.}

\item{ncluster}{The number of clusters present in the data.}

\item{lambda1}{The lambda 1 value to use in the SparseDC function. This
value controls the number of marker genes detected for each of the clusters
in the final result. This can be calculated using the "lambda1_calculator"
function or supplied by the user.}

\item{lambda2}{The lambda 2 value to use in the SparseDC function. This
value controls the number of genes that show condition-dependent
expression within each cell type. This can be calculated using the
"lambda2_calculator" function or supplied by the user.}
}
\value{
Returns a list containing the center values for each of the
clusters in condition 1 and 2.
}
\description{
This fucntion updates the center values for each cluster for each iteration
of SparseDC. This function runs inside \code{sparse_dc_fun}
}
