% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{by_PoolIndex,function,character,character-method}
\alias{by_PoolIndex,function,character,character-method}
\title{convert a function f of to f_vec}
\usage{
\S4method{by_PoolIndex}{`function`,character,character}(obj, poolNames, timeSymbol)
}
\arguments{
\item{obj}{For this method a function, whose formal arguments must have names that are elements of the union of poolNames and timeSymbol}

\item{poolNames}{The ordered poolnames}

\item{timeSymbol}{The name of the argument of obj that represents time.}
}
\value{
f_vec(vec,t)  A new function that extracts the arguments of obj from a complete vector of state variables and the time argument t and applies the original function to these arguments
The ode solvers used by SoilR expect a vector valued function of the state vector and time that represents the derivative.
The components of this vector are scalar functions of a vector argument and time. It is possible for the  user to define such functions directly, but the definition always depends on the order of state variables. Furthermore these functions usually do not use the complete state vector but only some parts of it.
It is much clearer more intuitive and less error prone to be able to define 
functions that have only formal arguments that are used. 
This is what this method is used for.
}
\description{
convert a function f of to f_vec
}
\examples{
leaf_resp=function(leaf_pool_content){leaf_pool_content*4}
leaf_resp(1)
poolNames=c(
   "some_thing"
  ,"some_thing_else"
  ,"some_thing_altogther"
  ,"leaf_pool_content"
)
leaf_resp_vec=by_PoolIndex(leaf_resp,poolNames,timeSymbol='t')
# The result is the same since the only the forth position in the vector
leaf_resp_vec(c(1,27,3,1),5) 
}
