% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fn_exp_categorical.R
\name{ExpStat}
\alias{ExpStat}
\title{Function provides summary statistics for individual categorical predictors}
\usage{
ExpStat(X, Y, valueOfGood = NULL)
}
\arguments{
\item{X}{Independent categorical variable.}

\item{Y}{Binary response variable, it can take values of either 1 or 0.}

\item{valueOfGood}{Value of Y that is used as reference category.}
}
\value{
The function provides summary statistics like

\itemize{
  \item \code{Unique} number of levels
  \item \code{Chi square} statistics
  \item \code{P} value
  \item \code{df} Degrees of freedom
  \item \code{IV} Information value
  \item \code{Predictive} class
}
}
\description{
Provides bivariate summary statistics for all the categorical predictors against target variables. Output includes chi - square value, degrees of freedom, information value, p-value
}
\details{
Summary statistics included Pearson's Chi-squared Test for Count Data, "chisq.test" which performs chi-squared contingency table tests and goodness-of-fit tests. If any NA value present in X or Y variable, which will be considered as NA as in category while computing the contingency table.

Also added unique levels for each X categorical variables and degrees of freedom
}
\examples{
X = mtcars$carb
Y = mtcars$am
ExpStat(X,Y,valueOfGood = 1)
}
\seealso{
\code{\link[stats:chisq.test]{chisq.test}}
}
