% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.R
\name{get_num_clust}
\alias{get_num_clust}
\title{Find optimal number of clusters}
\usage{
get_num_clust(
  data,
  hc_func = "ward.D2",
  max_k = 10,
  plot = TRUE,
  malig = FALSE,
  k = NA,
  plot_directory
)
}
\arguments{
\item{data}{cnv_data list object of cnv data from SlideCNA::prep_cnv_dat()}

\item{hc_func}{character string for which hierarchical clustering function to use}

\item{max_k}{integer of number max number of clusters to evaluate (2:max_k)}

\item{plot}{TRUE if plotting silhoutte scores per cluster}

\item{malig}{TRUE if only using malignant bins and FALSE if using all bins}

\item{k}{integer of optimal number of clusters, if known, and NA if not known}

\item{plot_directory}{output plot directory path}
}
\value{
An integer representing the number of clusters that optimizes the silhouette score
}
\description{
This function uses the Silhouette Method applied to CNV scores to determine the
best number of clusters to divide the binned beads into
}
