% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intercorr_pois_nb.R
\name{intercorr_pois_nb}
\alias{intercorr_pois_nb}
\title{Calculate Intermediate MVN Correlation for Poisson - Negative Binomial Variables: Correlation Method 1}
\usage{
intercorr_pois_nb(rho_pois_nb = NULL, lam = NULL, p_zip = 0,
  size = NULL, mu = NULL, p_zinb = 0, nrand = 100000, seed = 1234)
}
\arguments{
\item{rho_pois_nb}{a \code{k_pois x k_nb} matrix of target correlations; order of each type should be 1st regular, 2nd zero-inflated}

\item{lam}{a vector of lambda (mean > 0) constants for the regular and zero-inflated Poisson variables (see \code{stats::dpois});
the order should be 1st regular Poisson variables, 2nd zero-inflated Poisson variables}

\item{p_zip}{a vector of probabilities of structural zeros (not including zeros from the Poisson distribution) for the
zero-inflated Poisson variables (see \code{VGAM::dzipois}); if \code{p_zip} = 0, \eqn{Y_{pois}} has a regular Poisson
distribution; if \code{p_zip} is in (0, 1), \eqn{Y_{pois}} has a zero-inflated Poisson distribution;
if \code{p_zip} is in \code{(-(exp(lam) - 1)^(-1), 0)}, \eqn{Y_{pois}} has a zero-deflated Poisson distribution and \code{p_zip}
is not a probability; if \code{p_zip = -(exp(lam) - 1)^(-1)}, \eqn{Y_{pois}} has a positive-Poisson distribution
(see \code{VGAM::dpospois}); if \code{length(p_zip) < length(lam)}, the missing values are set to 0 (and ordered 1st)}

\item{size}{a vector of size parameters for the Negative Binomial variables (see \code{stats::dnbinom}); the order should be
1st regular NB variables, 2nd zero-inflated NB variables}

\item{mu}{a vector of mean parameters for the NB variables (*Note: either \code{prob} or \code{mu} should be supplied for all Negative Binomial variables,
not a mixture; default = NULL); order the same as in \code{size}; for zero-inflated NB this refers to
the mean of the NB distribution (see \code{VGAM::dzinegbin})}

\item{p_zinb}{a vector of probabilities of structural zeros (not including zeros from the NB distribution) for the zero-inflated NB variables
(see \code{VGAM::dzinegbin}); if \code{p_zinb} = 0, \eqn{Y_{nb}} has a regular NB distribution;
if \code{p_zinb} is in \code{(-prob^size/(1 - prob^size),} \code{0)}, \eqn{Y_{nb}} has a zero-deflated NB distribution and \code{p_zinb}
is not a probability; if \code{p_zinb = -prob^size/(1 - prob^size)}, \eqn{Y_{nb}} has a positive-NB distribution (see
\code{VGAM::dposnegbin}); if \code{length(p_zinb) < length(size)}, the missing values are set to 0 (and ordered 1st)}

\item{nrand}{the number of random numbers to generate in calculating the bound (default = 10000)}

\item{seed}{the seed used in random number generation (default = 1234)}
}
\value{
the \code{k_pois x k_nb} intermediate correlation matrix whose rows represent the \code{k_pois} Poisson variables and
    columns represent the \code{k_nb} Negative Binomial variables
}
\description{
This function calculates a \code{k_pois x k_nb} intermediate matrix of correlations for the
    Poisson and Negative Binomial variables by extending the method of Yahav & Shmueli (2012, \doi{10.1002/asmb.901}). The intermediate
    correlation between Z1 and Z2 (the standard normal variables used to generate the Poisson and Negative Binomial variables Y1 and Y2
    via the inverse CDF method) is calculated using a logarithmic transformation of the target correlation.  First, the upper and lower
    Frechet-Hoeffding bounds (mincor, maxcor) on \eqn{\rho_{Y1, Y2}} are simulated.  Then the intermediate correlation is found as follows:
    \deqn{\rho_{Z1, Z2} = \frac{1}{b} * log(\frac{\rho_{Y1, Y2} - c}{a}),}
    where \eqn{a = -(maxcor * mincor)/(maxcor + mincor)}, \eqn{b = log((maxcor + a)/a)}, and \eqn{c = -a}.
    The function adapts code from Amatya & Demirtas' (2016) package \code{\link[PoisNor]{PoisNor-package}} by:

    1) allowing specifications for the number of random variates and the seed for reproducibility

    2) providing the following checks: if \code{Sigma_(Z1, Z2)} > 1, \code{Sigma_(Z1, Z2)} is set to 1; if \code{Sigma_(Z1, Z2)} < -1,
    \code{Sigma_(Z1, Z2)} is set to -1

    3) simulating regular and zero-inflated Poisson and Negative Binomial variables.

    The function is used in \code{\link[SimCorrMix]{intercorr}} and \code{\link[SimCorrMix]{corrvar}} and would not ordinarily be called by the user.
}
\references{
Please see references for \code{\link[SimCorrMix]{intercorr_pois}}.
}
\seealso{
\code{\link[SimCorrMix]{intercorr_pois}}, \code{\link[SimCorrMix]{intercorr_nb}},
    \code{\link[SimCorrMix]{intercorr}}, \code{\link[SimCorrMix]{corrvar}}
}
\keyword{NegativeBinomial}
\keyword{Poisson}
\keyword{correlation}
\keyword{method1}
