% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SieveSGDFunction.R
\name{sieve.sgd.predict}
\alias{sieve.sgd.predict}
\title{Sieve-SGD makes prediction with new predictors.}
\usage{
sieve.sgd.predict(sieve.model, X)
}
\arguments{
\item{sieve.model}{a list initiated using sieve.sgd.preprocess and sieve.sgd.solver. Check the documentation of sieve.sgd.preprocess for more information.}

\item{X}{a data frame containing prediction features/ independent variables.}
}
\value{
sieve.sgd.predict will update the given sieve.model input list.
\item{inf.list}{In each entry of the list inf.list, the array prdy is the predicted outcome under the given hyperparameter combination.}
}
\description{
Sieve-SGD makes prediction with new predictors.
}
\examples{
frho.para <- xdim <- 1 ##predictor dimension
frho <- 'additive' ###truth is a sum of absolute functions 
type <- 'cosine' ###use cosine functions as the basis functions
#generate training data
TrainData <- GenSamples(s.size = 1e3, xdim = xdim, 
                                frho.para = frho.para, 
                                frho = frho, noise.para = 0.1)
#preprocess the model
sieve.model <- sieve.sgd.preprocess(X = TrainData[,2:(xdim+1)], 
                                    type = type,
                                    s = c(1,2),
                                    r0 = c(0.5, 2, 4),
                                    J = c(1, 4, 8))

##train the model
sieve.model <- sieve.sgd.solver(sieve.model = sieve.model, 
                                X = TrainData[,2:(xdim+1)], 
                                Y  = TrainData[,1])
##generate new data
NewData <- GenSamples(s.size = 5e2, xdim = xdim, 
                      frho.para = frho.para, 
                      frho = frho, noise.para = 0.1)
sieve.model <- sieve.sgd.predict(sieve.model, X = NewData[, 2:(xdim+1)])
plot(NewData[, 2:(xdim+1)], sieve.model$best_model$prdy)
}
