% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.alignment}
\alias{print.alignment}
\title{Print Alignments}
\usage{
\method{print}{alignment}(x, ...)
}
\arguments{
\item{x}{Object of class \code{alignment} (see \code{\link{align_sequences}}).}

\item{...}{Additional parameters to be passed to the \code{cat()} function, displaying the alignment.}
}
\value{
Console print of alignments.
}
\description{
Prints the alignments between \code{seq1} and \code{seq2} with the highest score.
}
\details{
The printed message includes the alignment score.
This function may display multiple alignments, as alignments with the same score are possible.
}
\examples{
seq1 <- "GCATGCG"
seq2 <- "GATTACA"
# Run the Needleman-Wunsch algorithm
alignment1 <- align_sequences(seq1, seq2, d = -1, mismatch = -1, match = 1)
# Print the alignments
print(alignment1)

}
