% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sb_beta.R
\name{sb_normalize}
\alias{sb_normalize}
\alias{sb_compute_corr}
\alias{sb_group_variables}
\title{Core helpers for SelectBoost-style beta regression}
\usage{
sb_normalize(X, center = NULL, scale = NULL, eps = 1e-08)

sb_compute_corr(X, corrfunc = "cor")

sb_group_variables(corr_mat, c0)
}
\arguments{
\item{X}{Numeric matrix of predictors.}

\item{center}{Optional centering vector recycled to the number of columns.
Defaults to the column means of \code{X}.}

\item{scale}{Optional scaling vector recycled to the number of columns.
Defaults to the column-wise \eqn{\ell_2} norms of the centred matrix.}

\item{eps}{Small positive constant used when normalising columns.}

\item{corrfunc}{Function or character string used to compute pairwise
associations. Defaults to \code{"cor"}.}

\item{corr_mat}{Numeric matrix of associations.}

\item{c0}{Threshold applied to the absolute correlations.}
}
\value{
\code{sb_normalize()} returns a centred, \eqn{\ell_2}-scaled copy of \code{X}.

\code{sb_compute_corr()} returns the association matrix.

\code{sb_group_variables()} returns a list of integer vectors, one per
variable, describing the correlated group it belongs to.
}
\description{
These helpers expose the individual stages of the SelectBoost workflow so
that beta-regression selectors can be combined with correlation-aware
resampling directly from \code{SelectBoost.beta}. They normalise the design matrix,
derive correlation structures, form groups of correlated predictors, generate
Gaussian surrogates that mimic the observed dependency structure, and apply a
user-provided selector on each resampled design.
}
\examples{
sb_normalize(matrix(rnorm(20), 5))
}
