% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{tfc_plot}
\alias{tfc_plot}
\title{plotting function for tercile forecasts}
\usage{
tfc_plot(
  dt,
  discrete_cs = TRUE,
  rmax = NULL,
  below = "brown",
  normal = "gold",
  above = "forestgreen",
  na.value = "gray75",
  cs_names = c("below", "normal", "above"),
  oob = NULL,
  guide_barwidth = grid::unit(0.01, units = "npc"),
  guide_barheight = grid::unit(0.15, units = "npc"),
  legend_horizontal = FALSE,
  binwidth = "auto",
  add_map = TRUE,
  extent = NULL,
  expand.x = c(0, 0),
  expand.y = c(0, 0),
  showplot = TRUE,
  dimension_check = TRUE
)
}
\arguments{
\item{dt}{Data table containing the data for plotting.}

\item{discrete_cs}{Logical. Do you want to use discrete color scales (default) or not.}

\item{rmax}{Optional value to fix the range of the colorscale (lower limit is always 0.33).}

\item{below, normal, above}{Colors to use for the three categories. Default is \code{'brown'}, \code{'gold'}, \code{'forestgreen'}.}

\item{na.value}{Color to use for missing value. Default is \code{'gray75'}.}

\item{cs_names}{Character vector of length three giving the legend titles for the below-, normal-, and above category.}

\item{oob}{Behavior for data above \code{r_max}. Passed to \code{\link[ggplot2:scale_colour_continuous]{ggplot2::scale_fill_continuous()}} if \code{discrete_cs == FALSE} or else to \code{\link[ggplot2:scale_steps]{ggplot2::scale_fill_steps()}}.}

\item{guide_barwidth, guide_barheight}{value to specify the width and height of the color guide. Are flipped if \code{legend_horizontal} is \code{TRUE}. Use \code{units(...,"npc")} to make it work across all output devices.}

\item{legend_horizontal}{Logical. Set to \code{TRUE} to show the legend horizontally underneath the plot.}

\item{binwidth}{Width of the steps when a discrete colorscale is used.}

\item{add_map}{logical, defaults to \code{TRUE}, mostly for internal use. Set to \code{FALSE} to remove borders (e.g. if you want to add them yourself from a shapefile).}

\item{extent}{An optional four-element vector in the order xmin,xmax,ymin,ymax for specifying the spatial extent of the plot. Default is to fit the extent to the data.}

\item{expand.x, expand.y}{vectors with two entries to be added to xlims/ylims of the plot. E.g. expand.x = c(-0.5,0.5)
expands the plot by half a longitude both on the right and left hand side.}

\item{showplot}{Logical. Should the plot be displayed at the end?}

\item{dimension_check}{Logical. By default the function checks that there are not multiple values per coordinate
(and subsets to the first level if there are several, e.g. to the first year and month (by appearance in \code{dt}) if \code{dt} contains data for several years and months).}
}
\value{
a ggplot object.
}
\description{
Plots spatial maps of tercile forecasts. Requires a data table with three columns \code{"below"}, \code{"normal"}, \code{"above"}
which sum to 1. For each gridpoint only the highest of the three values is plotted, so there are three colorscales.
}
\examples{
#dt = tfc_from_efc(ecmwf_monthly[month == 11 & lat < 0])
#pp = tfc_plot(dt[year == 2018])
#if(interactive()) plot(pp)

}
\author{
Claudio Heinrich
}
