% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_FOR.R
\name{seasonder_getFORParameter}
\alias{seasonder_getFORParameter}
\title{Retrieve a Specific FOR Parameter}
\usage{
seasonder_getFORParameter(seasonder_cs_object, FOR_parameter)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object containing FOR parameters.}

\item{FOR_parameter}{A character string specifying the name of the FOR parameter to retrieve.}
}
\value{
The value of the specified FOR parameter if found; otherwise, an error message is logged.
}
\description{
This function extracts a specified First Order Region (FOR) parameter from a SeaSondeRCS object.
}
\details{
The function retrieves the list of FOR parameters using \code{seasonder_getFOR_parameters()} and extracts
the value associated with \code{FOR_parameter}. If the parameter is not found, an error is logged.
}
\examples{
# Minimal example for seasonder_getFORParameter
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
cs_obj <- seasonder_createSeaSondeRCS(cs_file, seasonder_apm_object = apm_obj)
nsm_value <- seasonder_getFORParameter(cs_obj, "nsm")
print(nsm_value)
}
