% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_funs.R
\name{bb}
\alias{bb}
\title{Bayesian bootstrap posterior sampler for the CDF}
\usage{
bb(y)
}
\arguments{
\item{y}{the data from which to infer the CDF (preferably sorted)}
}
\value{
a function that can evaluate the sampled CDF at any argument(s)
}
\description{
Compute one Monte Carlo draw from the Bayesian bootstrap (BB)
posterior distribution of the cumulative distribution function (CDF).
}
\details{
Assuming the data \code{y} are iid from an unknown distribution,
the Bayesian bootstrap (BB) is a nonparametric model for this distribution. The
BB is a limiting case of a Dirichlet process prior (without
any hyperparameters) that admits direct Monte Carlo (not MCMC) sampling.

This function computes one draw from the BB posterior
distribution for the CDF \code{Fy}.
}
\note{
This code is inspired by \code{ggdist::weighted_ecdf}.
}
\examples{
# Simulate data:
y = rnorm(n = 100)

# One draw from the BB posterior:
Fy = bb(y)

class(Fy) # this is a function
Fy(0) # some example use (for this one draw)
Fy(c(.5, 1.2))

# Plot several draws from the BB posterior distribution:
ys = seq(-3, 3, length.out=1000)
plot(ys, ys, type='n', ylim = c(0,1),
     main = 'Draws from BB posterior', xlab = 'y', ylab = 'F(y)')
for(s in 1:50) lines(ys, bb(y)(ys), col='gray')

# Add ECDF for reference:
lines(ys, ecdf(y)(ys), lty=2)

}
