% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sd.R
\name{sd_stressed}
\alias{sd_stressed}
\alias{var_stressed}
\title{Standard Deviation and Variance of a Stressed Model}
\usage{
sd_stressed(object, xCol = "all", wCol = "all", base = FALSE)

var_stressed(object, xCol = "all", wCol = "all", base = FALSE)
}
\arguments{
\item{object}{A \code{SWIM} or \code{SWIMw} object.}

\item{xCol}{Numeric or character vector, (names of) the columns of 
the underlying data 
of the \code{object} (\code{default = "all"}).}

\item{wCol}{Vector, the columns of the scenario weights 
of the \code{object} corresponding to different 
stresses (\code{default = "all"}).}

\item{base}{Logical, if \code{TRUE}, statistics under the baseline 
are also returned (\code{default = "FALSE"}).}
}
\value{
\code{sd_stressed}: Return the standard deviation of the \code{xCol}
    component of the stressed model with weights \code{wCol}.
    The quantity can be evaluated at a vector.

\code{var_stressed}: Return the variance of the \code{xCol}
    component of the stressed model with weights \code{wCol}.
    The quantity can be evaluated at a vector.
}
\description{
Provides the standard deviation and variance of stressed 
    model components (random variables) under the scenario weights.
}
\details{
\code{sd_stressed}: The standard deviation of 
     a chosen model component, subject to the calculated scenario weights.

\code{var_stressed}: The variance of 
     a chosen stressed model component, subject to the calculated scenario weights.
}
\section{Functions}{
\itemize{
\item \code{sd_stressed}: Sample standard deviation of model components

\item \code{var_stressed}: Sample variance of model components
}}

\examples{
     
## example with a stress on VaR
set.seed(0)
x <- as.data.frame(cbind(
  "normal" = rnorm(1000), 
  "gamma" = rgamma(1000, shape = 2)))
res1 <- stress(type = "VaR", x = x, 
  alpha = c(0.9, 0.95), q_ratio = 1.05)
## stressed standard deviation
sd_stressed(res1, xCol = "all", wCol = "all", base = TRUE)

## stressed variance
var_stressed(res1, xCol = "all", wCol = "all", base = TRUE)

}
\seealso{
See \code{\link{mean_stressed}} for means of stressed model components,
and \code{\link{cor_stressed}} for correlations between stressed model components.
}
\author{
Kent Wu
}
