% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_stats.R
\name{binarize_expression}
\alias{binarize_expression}
\title{Binarize Gene Expression}
\usage{
binarize_expression(
  expr_matrix,
  method = c("kmeans", "rank", "median", "mean"),
  rank_percent = 30,
  n_threads = 1L,
  verbose = FALSE
)
}
\arguments{
\item{expr_matrix}{Numeric matrix of gene expression.
Rows are genes, columns are spots/cells.}

\item{method}{Character string specifying binarization method.
\itemize{
  \item \code{"kmeans"} (default): Use k-means clustering (k=2) to separate
    high and low expression
  \item \code{"rank"}: Binarize based on expression rank percentile
  \item \code{"median"}: Values above median are set to 1
  \item \code{"mean"}: Values above mean are set to 1
}}

\item{rank_percent}{Numeric. For \code{method = "rank"}, the percentile
threshold (0-100). Values in the top \code{rank_percent} percent are set to 1.
Default is 30.}

\item{n_threads}{Integer. Number of threads for parallel computation.
Default is 1.}

\item{verbose}{Logical. Whether to print progress. Default is FALSE.}
}
\value{
Binary matrix with same dimensions as input.
}
\description{
Converts continuous gene expression values to binary (0/1) using various methods.
Used by the binSpect method.
}
\details{
\strong{K-means method:}
For each gene, k-means clustering with k=2 is applied. The cluster with
higher mean expression is labeled as 1, the other as 0.

\strong{Rank method:}
For each gene, spots are ranked by expression. The top \code{rank_percent}
percent are labeled as 1.
}
\examples{
# Create example expression matrix
expr <- matrix(rpois(1000, lambda = 10), nrow = 10, ncol = 100)
rownames(expr) <- paste0("gene_", 1:10)

# Binarize using k-means
bin_kmeans <- binarize_expression(expr, method = "kmeans")

# Binarize using rank (top 20\%)
bin_rank <- binarize_expression(expr, method = "rank", rank_percent = 20)

}
