% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SVG-package.R
\docType{package}
\name{SVG-package}
\alias{SVG}
\alias{SVG-package}
\title{SVG: Spatially Variable Genes Detection Methods for Spatial Transcriptomics}
\description{
A unified framework for detecting spatially variable genes (SVGs) in spatial transcriptomics data. This package integrates multiple state-of-the-art SVG detection methods including 'MERINGUE' (Moran's I based spatial autocorrelation), 'Giotto' binSpect (binary spatial enrichment test), 'SPARK-X' (non-parametric kernel-based test), and 'nnSVG' (nearest-neighbor Gaussian processes). Each method is implemented with optimized performance through vectorization, parallelization, and 'C++' acceleration where applicable. Methods are described in Miller et al. (2021) \doi{10.1101/gr.271288.120}, Dries et al. (2021) \doi{10.1186/s13059-021-02286-2}, Zhu et al. (2021) \doi{10.1186/s13059-021-02404-0}, and Weber et al. (2023) \doi{10.1038/s41467-023-39748-z}.

A unified framework for detecting spatially variable genes (SVGs) in spatial
transcriptomics data. This package integrates multiple state-of-the-art SVG
detection methods:

\itemize{
  \item \strong{MERINGUE}: Moran's I with binary adjacency network
  \item \strong{Seurat}: Moran's I with inverse distance weights
  \item \strong{binSpect}: Binary spatial enrichment test (from Giotto)
  \item \strong{SPARK-X}: Non-parametric kernel-based test
  \item \strong{nnSVG}: Nearest-neighbor Gaussian processes
  \item \strong{MarkVario}: Mark variogram (from spatstat)
}
}
\section{Main Functions}{

\itemize{
  \item \code{\link{CalSVG}}: Unified interface for all SVG methods
  \item \code{\link{CalSVG_MERINGUE}}: MERINGUE method (Moran's I with network)
  \item \code{\link{CalSVG_Seurat}}: Seurat method (Moran's I with 1/d^2 weights)
  \item \code{\link{CalSVG_binSpect}}: Giotto binSpect method
  \item \code{\link{CalSVG_SPARKX}}: SPARK-X method
  \item \code{\link{CalSVG_nnSVG}}: nnSVG method (requires BRISC)
  \item \code{\link{CalSVG_MarkVario}}: Mark variogram method
}
}

\section{Utility Functions}{

\itemize{
  \item \code{\link{buildSpatialNetwork}}: Build spatial neighborhood network
  \item \code{\link{moranI}}: Calculate Moran's I statistic
  \item \code{\link{binarize_expression}}: Binarize gene expression
}
}

\references{
\itemize{
  \item Miller, B.F. et al. (2022) nnSVG for spatial transcriptomics. Nature Communications.
  \item Sun, S. et al. (2020) Statistical analysis of spatial expression patterns. Nature Methods.
  \item Dries, R. et al. (2021) Giotto: a toolbox for spatial transcriptomics. Genome Biology.
  \item Miller, J.A. et al. (2021) MERINGUE: characterizing spatial gene expression. Genome Research.
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/Zaoqu-Liu/SVG}
  \item \url{https://zaoqu-liu.github.io/SVG/}
  \item Report bugs at \url{https://github.com/Zaoqu-Liu/SVG/issues}
}

}
\author{
\strong{Maintainer}: Zaoqu Liu \email{liuzaoqu@163.com} (\href{https://orcid.org/0000-0002-0452-742X}{ORCID})

Other contributors:
\itemize{
  \item SVGbench Contributors (Original method implementations) [contributor]
}


Zaoqu Liu \email{liuzaoqu@163.com}
}
\keyword{internal}
