% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fst.R
\name{fst}
\alias{fst}
\title{Functional Stationarity Test}
\usage{
fst(
  X,
  STAT = 1,
  ALPHA = 0.05,
  METHOD = "MC",
  K = default_kernel,
  h_power = 2/5,
  est_ev = nrow(X),
  MCNsim = 10000,
  bb_set = NULL,
  dbb_set = NULL,
  M = 1000,
  b = ceiling((2 * nrow(X))^(1/3))
)
}
\arguments{
\item{X}{The functional time series being tested, inputted in a matrix form with each row representing each observation of the functional data values on equidistant points of any prespecified interval.}

\item{STAT}{Test statistic used in the stationarity test. The default value 'STAT=1' represents 'T_N' and 'STAT=2' represents 'M_N' in original paper.}

\item{ALPHA}{Significance level of the test. The default value is 5\%.}

\item{METHOD}{Method to determine the critical value of the test statistic. The default value 'METHOD="MC"' represents the Monte Carlo method. 'METHOD="SB"' represents the simple bootstrap method and 'METHOD="MBB"' represents the moving block bootstrap method.}

\item{K}{Kernel function in the estimation of the long-run covariance function, which is only effective in the Monte Carlo method. The default function is 'default_kernel' function in this package.}

\item{h_power}{Power of sample size 'N' (valued in (0,1)) for the smoothing bandwidth, which is only effective in the Monte Carlo method. The default value is 2/5.}

\item{est_ev}{Number of the largest eigenvalues chosen to estimate the limiting distribution, which is only effective in the Monte Carlo method. The default value is the sample size 'N'.}

\item{MCNsim}{Number of Monte Carlo datasets generated in the Monte Carlo method, which is only effective in Monte Carlo method. The default value is 10000.}

\item{bb_set}{A vector of independent simulated data generated from the function 'dataset_bb', which is only effective and essential in Monte Carlo method with 'STAT=1'.}

\item{dbb_set}{A vector of independent simulated data generated from the function 'dataset_dbb', which is only effective and essential in Monte Carlo method with 'STAT=2'.}

\item{M}{Number of bootstrap datasets generated in the bootstrap method, which is only effective in bootstrap methods. The default value is 1000.}

\item{b}{Block length used in the moving block bootstrap method, which is only effective in the moving block bootstrap method. The default value is ceiling((2N)^(1/3)), where 'N' is the sample size.}
}
\value{
The result of the test is presented with the value of test statistic and its p-value under the null hypothesis of local stationarity.
}
\description{
Stationarity test for functional time series with different methods on determining the critical values of the test statistic. The Monte Carlo method was constructed in Horvath et al. (2014), while the bootstrap-based methods have not been validated in the literature (although such an option is provided, please use them at your own risk).
}
\examples{
N<-100
EX<-matrix(rep(0,N*100),ncol=100)
set.seed(1)
for (i in 1:N) {
temp<-rnorm(100,0,1)
EX[i,1]<-temp[1]
for (j in 2:100) {
EX[i,j]<-EX[i,j-1]+temp[j]
}
}
fst(X=EX,METHOD="SB")
}
\references{
Horvath, L., Kokoszka, P., & Rice, G. (2014). Testing stationarity of functional time series. Journal of Econometrics, 179(1), 66-82.
}
