% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_likelihood_noGEV.R
\name{log_likelihood_noGEV}
\alias{log_likelihood_noGEV}
\title{Compute Log-Likelihood for a Generalized Dynamic Copula Model without GEV covariates}
\usage{
log_likelihood_noGEV(params, U, Z, X, copula)
}
\arguments{
\item{params}{Numeric vector of model parameters, including copula parameters
(omega, alpha, gamma).}

\item{U}{Numeric matrix (n_train x D), pseudo-observations for the copula.}

\item{Z}{Numeric array (n_train x D x M), observed data for each margin and sub-feature.}

\item{X}{Numeric matrix (n_train x M), risk factors for the dynamic copula parameter.}

\item{copula}{Character, specifying the copula type: "Clayton", "Frank",
"Gumbel", "Joe", or "Gaussian".}
}
\value{
Numeric, negative log-likelihood value.
}
\description{
Computes the log-likelihood for a time-varying copula model.
}
\examples{
test_ll_noGEV <- log_likelihood_noGEV(init_params_noGEV,uu,
                      zz_train,x_train,"Gaussian")

}
