% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.R
\name{labels.SSN2}
\alias{labels.SSN2}
\alias{labels.ssn_lm}
\alias{labels.ssn_glm}
\title{Find labels from object}
\usage{
\method{labels}{ssn_lm}(object, ...)

\method{labels}{ssn_glm}(object, ...)
}
\arguments{
\item{object}{A fitted model object from \code{\link[=ssn_lm]{ssn_lm()}} or \code{\link[=ssn_glm]{ssn_glm()}}.}

\item{...}{Other arguments. Not used (needed for generic consistency).}
}
\value{
A character vector containing the terms used for the fixed effects
from a fitted model object.
}
\description{
Find a suitable set of labels from a fitted model object.
}
\examples{
# Copy the mf04p .ssn data to a local directory and read it into R
# When modeling with your .ssn object, you will load it using the relevant
# path to the .ssn data on your machine
copy_lsn_to_temp()
temp_path <- paste0(tempdir(), "/MiddleFork04.ssn")
mf04p <- ssn_import(temp_path, overwrite = TRUE)

ssn_mod <- ssn_lm(
  formula = Summer_mn ~ ELEV_DEM,
  ssn.object = mf04p,
  tailup_type = "exponential",
  additive = "afvArea"
)
labels(ssn_mod)
}
