% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSM_class.R
\docType{package}
\name{SSM}
\alias{SSM-package}
\title{SSM: A package for fitting smooth supersaturated models (SSM).}
\description{
The SSM package provides an S4 class to represent smooth supersaturated
models, along with functions for fitting SSM to data, computing Sobol indices
for the SSM and estimating metamodel error with a Gaussian process.
}
\section{SSM functions}{

There are three important functions in the package.

\code{fit.ssm} returns an SSM object that fits an SSM to the data and, by
default, computes the Sobol indices, and Total interaction indices of the
model.  Optionally, the metamodel error can be estimated using a Gaussian
process.  The fitted SSM smooths over \eqn{[-1, 1]^d} and uses a hierarchical
basis of 20*d+n Legendre polynomials by default but the function is highly
customisable.

\code{predict.SSM} returns the model prediction at a point, including a
credible interval if a metamodel error GP has been fit.

\code{plot.SSM} plots the main effects of the SSM.
}

