% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributionBootMER.R
\name{distributionBootMER}
\alias{distributionBootMER}
\title{Bootstrap a null distribution of the test statistic for mixed effect model}
\usage{
distributionBootMER(
  nBoot,
  seed,
  parametric = TRUE,
  MERSObject1,
  MERSObject2,
  randomFormula,
  splineRule,
  lmmFormula,
  varName,
  knotType = 1,
  nBasis = 5,
  increasing = TRUE,
  convex = TRUE,
  testStat = NULL
)
}
\arguments{
\item{nBoot}{The number of bootstrap iterations.}

\item{seed}{The seed.}

\item{parametric}{The method of blup and noise bootstrap: T=resample from estimated blup and noise, F=resample from normal}

\item{MERSObject1}{The lmm model under null distribution.}

\item{MERSObject2}{The lmm model fitted using iSplineMER or cSplineMER}

\item{randomFormula}{The formula used to generate random effect matrix (in the form of ~random+0)}

\item{splineRule}{iSplineMER or cSplineMER}

\item{lmmFormula}{A linear mixed effect model formula (same as lmmFormula in iSplineMER or cSplineFMER).}

\item{varName}{The name of the main effect (same as varName in iSplineMER or cSplineMER).}

\item{knotType}{The knot type: 1=equal-spaced and 2=quantile (same as knotType in iSplineMER or cSplineMER).}

\item{nBasis}{The number of bases (same as nBasis in iSplineMER or cSplineMER).}

\item{increasing}{Increasing shape or Decreasing shape: T=Increasing, F=Decreasing}

\item{convex}{Convex shape or Concave shape: T=Convex, F=Concave}

\item{testStat}{The test statistic generated from iSplineMER or cSplineMER}
}
\value{
A list of null distribution of test statistic and p value.
}
\description{
Bootstrap a null distribution of the test statistic for mixed effect model
}
\keyword{internal}
