% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/native.cont.R
\name{native.cont}
\alias{native.cont}
\title{Select native contact distances}
\usage{
native.cont(
  struct = NULL,
  trj = NULL,
  trj.frame = 1,
  distance,
  mol.2 = FALSE,
  atoms = NULL
)
}
\arguments{
\item{struct}{a struct object read with read.struct() to compute the native.cont}

\item{trj}{a trj object to compute the native.cont}

\item{trj.frame}{The frame of the trj on which the native.cont are computed}

\item{distance}{the distance cut-off}

\item{mol.2}{can be FALSE (default), use the whole distance matrix, or a vector containing the atomic number of the second molecule (and compute only intermolecular distances)}

\item{atoms}{can be NULL (default), consider all the atoms present in coords, or a vector containing a set of atomic numbers to consider in the calculation (e.g. only CB). atoms can be obtained with the bio3d atom.select function}
}
\value{
A vector containing the index of a subset of selected distances
}
\description{
Function to select only distances between residues making contacts in reference file or a frame of the simulation
}
\examples{
# Read reference structure file with native conformation
struct <- read.struct(system.file("extdata", "HIF2a.gro", package = "SOMMD"))
#Select only Cbeta atoms to perform the analysis
sele_atoms <- which(struct$atom$elety=="CB")
#Choose only native contacts
sele_dists <- native.cont(struct=struct, distance=1.0, atoms=sele_atoms)

}
\author{
Stefano Motta \email{stefano.motta@unimib.it}
}
