% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contr.TianXu.R
\name{contr.TianXu}
\alias{contr.TianXu}
\title{A complex-valued contrast function for s^el levels based on powers of the s-th
root of the unity}
\usage{
contr.TianXu(n, s = 2, contrasts = TRUE)
}
\arguments{
\item{n}{integer or vector; either an integer number of levels of the factor for
which contrasts are created, which must be a a power of \code{s}; or a factor
whose number of levels is a power of \code{s}; or a vector of levels whose
number of elements is a power of \code{s}.}

\item{s}{positive integer, at least 2}

\item{contrasts}{logical; must be TRUE}
}
\value{
\code{contr.TianXu} yields a matrix of complex-valued contrasts.
It can therefore NOT be used in function \code{model.matrix}
or in statistical modeling functions.
}
\description{
A complex-valued contrast function for s^el levels based on powers of the s-th
root of the unity
}
\details{
The function implements the complex-valued contrasts from
Tian and Xu (2022). Its sole use is the calculation of the
stratification pattern (also called space-filling pattern).
However, note that it is not used in function \code{\link{Spattern}},
but only in the internal function \code{Spattern_TianXu},
which yields exactly the same results as function \code{Spattern}.\cr
The \code{contrasts} argument has been kept in order to be
prepared in case the \code{model.matrix} function gains the
ability to handle complex-valued contrasts.

The Tian and Xu contrasts are full-factorial-based contrasts
in the sense of Groemping (2023b). Function \code{\link{Spattern}}
uses a different type of full-factorial-based contrasts,
the full-factorial-based Helmert contrasts provided in function
\code{\link{contr.FFbHelmert}}.
}
\examples{
## the same n can yield different contrasts for different s
contr.TianXu(16, 2)
contr.TianXu(16, 4)
round(contr.TianXu(16, 16), 4)

}
\references{
Groemping (2023b)
Tian and Xu (2022)
}
