% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_summary_print_HD.R
\name{summary.SNSeg_HD}
\alias{summary.SNSeg_HD}
\title{Summary of SN-based change-point estimates for high-dimensional time series
with dimension greater than 10}
\usage{
\method{summary}{SNSeg_HD}(object, ...)
}
\arguments{
\item{object}{a \code{SNSeg_HD} object}

\item{...}{not in use}
}
\description{
Summary method for objects of class \code{SNSeg_HD}
}
\details{
Provide information about estimated change-point locations, the
parameter tested by SN-based procedures, the confidence level, the \code{grid_size},
and the critical value of the SN-based test.
}
\examples{
\donttest{
n <- 500
p <- 50
nocp <- 5
cp_sets <- round(seq(0,nocp+1,1)/(nocp+1)*n)
num_entry <- 5
kappa <- sqrt(4/5)
mean_shift <- rep(c(0,kappa),100)[1:(length(cp_sets)-1)]
set.seed(1)
ts <- matrix(rnorm(n*p,0,1),n,p)
no_seg <- length(cp_sets)-1
for(index in 1:no_seg){
  tau1 <- cp_sets[index]+1
  tau2 <- cp_sets[index+1]
  ts[tau1:tau2,1:num_entry] <- ts[tau1:tau2,1:num_entry] +
    mean_shift[index]
}

# grid_size defined
result <- SNSeg_HD(ts, confidence = 0.9, grid_size_scale  = 0.05,
                   grid_size = 40)
# summary method
summary(result)
}

}
