% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.SLRMss.R
\name{residuals.SLRMss}
\alias{residuals.SLRMss}
\title{Extract residuals model for SLRMss objects}
\usage{
\method{residuals}{SLRMss}(object, H0 = FALSE, std = FALSE, ...)
}
\arguments{
\item{object}{An object of class \code{SLRMss}.}

\item{H0}{If TRUE, choose the residuals under null hypothesis, if FALSE, choose the residuals under alternative hypothesis (default).}

\item{std}{If TRUE, choose the standardized residuals, if FALSE, choose the non-standardized residuals (default).}

\item{...}{Currently ignored.}
}
\value{
Residuals extracted from a SLRMss object.
}
\description{
This function provides the residuals of a SLRMss model.
}
\examples{
data(orange)
fit <- SLRMss(emulsion ~ arabicgum + xanthangum + orangeoil, family="Student",
xi=3, testingbeta="xanthangum", statistic="LR", data=orange)
residuals(fit)
}
