% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-SimParamBee.R
\name{nWorkersPoisson}
\alias{nWorkersPoisson}
\alias{nWorkersTruncPoisson}
\alias{nWorkersColonyPhenotype}
\title{Sample a number of workers}
\usage{
nWorkersPoisson(colony, n = 1, average = 100)

nWorkersTruncPoisson(colony, n = 1, average = 100, lowerLimit = 0)

nWorkersColonyPhenotype(
  colony,
  queenTrait = 1,
  workersTrait = NULL,
  checkProduction = FALSE,
  lowerLimit = 0,
  simParamBee = NULL,
  ...
)
}
\arguments{
\item{colony}{\code{\link[SIMplyBee]{Colony-class}}}

\item{n}{integer, number of samples}

\item{average}{numeric, average number of workers}

\item{lowerLimit}{numeric, returned numbers will be above this value}

\item{queenTrait}{numeric (column position) or character (column name), trait
that represents queen's effect on the colony phenotype (defined in
\code{\link[SIMplyBee]{SimParamBee}} - see examples); if \code{0} then this effect is 0}

\item{workersTrait}{numeric (column position) or character (column name), trait
that represents workers's effect on the colony phenotype (defined in
\code{\link[SIMplyBee]{SimParamBee}} - see examples); if \code{0} then this effect is 0}

\item{checkProduction}{logical, does the phenotype depend on the production
status of colony; if yes and production is not \code{TRUE}, the result is
above \code{lowerLimit}}

\item{simParamBee}{\code{\link[SIMplyBee]{SimParamBee}}, global simulation parameters}

\item{...}{other arguments of \code{\link[SIMplyBee]{mapCasteToColonyPheno}}}
}
\value{
numeric, number of workers
}
\description{
Sample a number of workers - used when \code{nInd = NULL}
  (see \code{\link[SIMplyBee]{SimParamBee}$nWorkers}).

  This is just an example. You can provide your own functions that satisfy
  your needs!
}
\details{
\code{nWorkersPoisson} samples from a Poisson distribution with a
  given average, which can return a value 0. \code{nDronesTruncPoisson}
  samples from a zero truncated Poisson distribution.

  \code{nWorkersColonyPhenotype} returns a number (above \code{lowerLimit})
  as a function of colony phenotype, say queen's fecundity. Colony phenotype
  is provided by \code{\link[SIMplyBee]{mapCasteToColonyPheno}}. You need to set up
  traits influencing the colony phenotype and their parameters (mean and
  variances) via \code{\link[SIMplyBee]{SimParamBee}} (see examples).
}
\section{Functions}{
\itemize{
\item \code{nWorkersTruncPoisson()}: Sample a non-zero number of workers

\item \code{nWorkersColonyPhenotype()}: Sample a non-zero number of workers based on
colony phenotype, say queen's fecundity

}}
\examples{
nWorkersPoisson()
nWorkersPoisson()
n <- nWorkersPoisson(n = 1000)
hist(n, breaks = seq(from = min(n), to = max(n)), xlim = c(0, 200))
table(n)

nWorkersTruncPoisson()
nWorkersTruncPoisson()
n <- nWorkersTruncPoisson(n = 1000)
hist(n, breaks = seq(from = min(n), to = max(n)), xlim = c(0, 200))
table(n)

# Example for nWorkersColonyPhenotype()
founderGenomes <- quickHaplo(nInd = 3, nChr = 1, segSites = 100)
SP <- SimParamBee$new(founderGenomes)
\dontshow{SP$nThreads = 1L}
average <- 100
h2 <- 0.1
SP$addTraitA(nQtlPerChr = 100, mean = average, var = average * h2)
SP$setVarE(varE = average * (1 - h2))
basePop <- createVirginQueens(founderGenomes)
drones <- createDrones(x = basePop[1], nInd = 50)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 2, nDrones = 15)
colony1 <- createColony(x = basePop[2])
colony2 <- createColony(x = basePop[3])
colony1 <- cross(colony1, drones = droneGroups[[1]])
colony2 <- cross(colony2, drones = droneGroups[[2]])
colony1@queen@pheno
colony2@queen@pheno
createWorkers(colony1, nInd = nWorkersColonyPhenotype)
createWorkers(colony2, nInd = nWorkersColonyPhenotype)
}
\seealso{
\code{\link[SIMplyBee]{SimParamBee}} field \code{nWorkers} and
  \code{vignette(topic = "QuantitativeGenetics", package = "SIMplyBee")}
}
