% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen.neighbors.tabu.R
\name{gen.neighbors.tabu}
\alias{gen.neighbors.tabu}
\title{A Function that Generates a List of Neighbors in Tabu Search}
\usage{
gen.neighbors.tabu(
  current.param,
  maximum,
  neigh.size,
  tabu.list,
  max.len,
  range,
  r,
  f,
  max.attempts = 10
)
}
\arguments{
\item{current.param}{The center of the hypercubes.}

\item{maximum}{Logical. Maximize the objective function if TRUE,
minimize the objective function if FALSE.}

\item{neigh.size}{Number of neighbors to search for in each
iteration.}

\item{tabu.list}{The list of tabu.}

\item{max.len}{The length of the largest hypercube.}

\item{range}{The range for the parameter space in the tabu search.}

\item{r}{Radius of a tabu ball.}

\item{f}{The objective function to be optimized.}

\item{max.attempts}{The maximum number of attempts to find a neighbor that
is not near the points in the tabu list, default is 10.}
}
\value{
A list of information about the best neighbor, including
    best parameters, objective function values, and the model.
}
\description{
This function generates a list of neighbors for tabu
    search that can be used in tabu search for sensitivity analysis.
}
