% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathway_analysis.R
\name{gsea_heatmap}
\alias{gsea_heatmap}
\title{Heatmap to demonstrate enrichment of selected gene-sets}
\usage{
gsea_heatmap(
  normdata,
  teststats,
  gmtfile,
  numgenes,
  gsname_up,
  gsname_down,
  anncol,
  color,
  anncolors = NULL,
  rankcol = TRUE,
  zscore_range = c(-3, 3)
)
}
\arguments{
\item{normdata}{a matrix-like object of normalized & untransformed bulk RNA-seq data, with rows representing genes and columns representing samples.
The first element of the output from function \code{\link{run_de}}.}

\item{teststats}{a data.frame containing differential expression results with five columns: "Gene name", "log2 fold change", "log2 average expression",
"p value", "adjusted p value". The second element of the output from function \code{\link{run_de}}.}

\item{gmtfile}{path to gmt file used for GSEA analysis.}

\item{numgenes}{Number of genes to include in the heatmap. Will choose \code{numgenes} # of top up-regulated genes, as well as \code{numgenes} # of down-regulated genes}

\item{gsname_up}{a character value indicating selected up-regulated gene-set.}

\item{gsname_down}{a character value indicating selected down-regulated gene-set.}

\item{anncol}{a data.frame of sample meta information to include as column annotation bars. See option annCol from \code{\link[NMF]{aheatmap}} for more details.}

\item{color}{color used for heatmap. See option color option from \code{\link[NMF]{aheatmap}} for details.}

\item{anncolors}{optional data.frame to define colors for column annotations in \code{anncol}.}

\item{rankcol}{a logical value indicating whether to sort samples based on correlation between fold change & gene expression for better visualization. Default to TRUE.}

\item{zscore_range}{a vector of length two indicating the desired range of z-score transformed data. Default to c(-3, 3).}
}
\value{
a heatmap outputted from \code{aheatmap} function from \code{NMF} package
}
\description{
Heatmap to demonstrate enrichment of selected gene-sets.
}
\details{
this function does not support output from GSEA \href{https://github.com/GSEA-MSigDB/GSEA_R}{R implementation}
}
