% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sGGM.R
\name{sggm}
\alias{sggm}
\title{Model selection of Gaussian graphical model based on SBIC}
\usage{
sggm(data, lambda, M, prob)
}
\arguments{
\item{data}{An n by p dataframe representing the observations}

\item{lambda}{A vector of tuning parameters used to build the model pool}

\item{M}{The prior adjacency matrix}

\item{prob}{The mean error rate}
}
\value{
A list of objects containing: 
  \item{networkhat}{The final selected adjacency matrix}
  \item{candidates}{The model pool}
}
\description{
Select the model based on the SBIC criterion and the two-step algorithm
}
\examples{
\donttest{
   set.seed(1)
   m1 = 100
   m2 = 30
   p = 100
   n = 100
   d=simulate(n=n,p=p, m1 = m1, m2 = m2) # simulate fake data 
   lambda=exp(seq(-5,5,length=100)) # tuning parameter
   data=d$data # data from the simulation
   M=d$priornetwork # prior network from simulation
   # calculating the error rate 
   r1=m2/m1
   r2=m2/(p*(p-1)/2-m1)
   r=(r1+r2)/2
   # apply sggm 
   result=sggm(data=data, lambda=lambda, M=M, prob=r)
   # compare the final network and the true network 
   result$networkhat
   d$realnetwork
}
}
\author{
Jie Zhou
}
