% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbic.R
\name{sbic}
\alias{sbic}
\title{Structural Bayesian information criterion for multivariate normal data with a given graph structure}
\usage{
sbic(data, theta, prob, P)
}
\arguments{
\item{data}{A \code{n} by \code{p} dataframe representing observations}

\item{theta}{The \code{p} by \code{p} matrix representing the given graph structure}

\item{prob}{The expected error rate}

\item{P}{The prior adjacency matrix}
}
\value{
The value of sbic with given temperature parameter and prior adjacency matrix
}
\description{
This function estimates the novel structural Bayesian information criterion given the data and
  a given graph structure
}
\examples{
  set.seed(1)
  d=simulate(n=100, p=100, m1 = 100, m2 = 30)
  data=d$data
  P=d$priornetwork
  theta=d$realnetwork
  prob=0.15
  index=sbic(data=data, theta=theta, prob=prob, P=P)

}
\author{
Jie Zhou
}
