\name{annoter_image.moodle}
\alias{annoter_image.moodle}
\title{
  Créer une question demande d'annoter une image
}
\description{
  Cette fonction permet de créer une question affichant une image et des champs de texte à compléter pour annoter cette image.
}
\usage{
annoter_image.moodle( texte, titre = "Annoter la figure...",
                      f.creer_figure,
                      fichier.image,
                      legendes, 
                      x.numeros, y.numeros, 
                      numeros = if ( superposer ) rep( "", length( legendes ) )
		          else 1:length( legendes ),
                      superposer = all( !missing( x.numeros ),
                                        !missing( y.numeros ) ),
                      description.image = NULL, n.colonnes = 1,
                      commentaire.global = NA, penalite = NA, note.question = NA,
                      idnum = NA, temps, tags = NULL,
                      fichier.xml = get( "fichier.xml", envir = SARP.Moodle.env ),
                      ... )
}
\arguments{
  \item{texte}{ L'énoncé de la question (une chaîne de caractères). Cet
  énoncé peut contenir n'importe quel caractère (codage en UTF-8) et
  n'importe quelles balises HTML.  }

  \item{titre}{ L'intitulé de la question, en HTML. }

  \item{f.creer_figure}{ La fonction qui va construire l'image et les
    zones sur lesquelles déposer les éléments (voyez les détails,
    ci-dessous). }

  \item{fichier.image}{ Le nom du fichier contenant l'image à
    légender. Ignoré si \code{f.creer_figure} est fournie.}

  \item{legendes}{ Les textes à entrer dans les champs (réponses
  attendues) }

  \item{x.numeros, y.numeros}{ Les coordonnées des points où placer le
  champ texte, sur l'image (exprimées en pixels). Si l'un, ou les
  deux, sont absents, les champs textes apparaîtront en-dessous de
  l'image. Si les deux sont présents, les champs apparaîtront sur
  l'image.}

  \item{numeros}{Le texte à faire apparaître avant chaque champ
  (typiquement, un numéro de champ)}

  \item{superposer}{Veut-on superposer les champs à l'image
  (\code{TRUE}) ou non (\code{FALSE})?}

  \item{description.image}{Le texte alternatif à l'image à utiliser
  dans la balise HTML insérant l'image}

  \item{n.colonnes}{Si les champs sont placés sous l'image, les uns
  en-dessous des autres, sur combien de colonnes doivent-ils être
  répartis?}
    
  \item{commentaire.global, penalite, note.question, idnum,
    tags}{Options communes à toutes les questions Moodle, voyez
    \code{\link{debut_question.moodle}}.}

  \item{temps}{ Le temps conseillé pour répondre à la question, en
    minutes. }

  \item{fichier.xml}{ Le fichier correspondant au questionnaire qui
    contiendra cette question (par défaut, le dernier créé).  }

  \item{\dots}{ Arguments additionnels qui seront passés à
    \code{f.creer_figure}.}
}

\details{ À venir... }

\value{
  Aucune valeur n'est renvoyée par cette fonction.
}
\author{
  Emmanuel Curis \email{emmanuel.curis@parisdescartes.fr}
}
