% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tangle_gram.R
\name{tangle_gram}
\alias{tangle_gram}
\title{Tanglegram of the host-symbiont frequencies}
\usage{
tangle_gram(
  treeH,
  treeS,
  HS,
  fqtab,
  colscale = "diverging",
  colgrad,
  nbreaks = 50,
  node.tag = TRUE,
  cexpt = 1,
  link.lwd = 1,
  link.lty = 1,
  fsize = 0.5,
  pts = FALSE,
  link.type = "straight",
  ftype = "i",
  ...
)
}
\arguments{
\item{treeH}{Host phylogeny. An object of class \code{"phylo"}.}

\item{treeS}{Symbiont phylogeny. An object of class \code{"phylo"}.}

\item{HS}{Host-symbiont association matrix.}

\item{fqtab}{Dataframe produced with \code{\link[=max_cong]{max_cong()}} or
\code{\link[=max_incong]{max_incong()}}.}

\item{colscale}{Choose between \code{"diverging"}, color reflects distance
from 0 (centered at 0, recommended if \code{"res.fq = TRUE"})
or \code{"sequential"}, color reflects distance from minimum value
(spanning from the min to max frequencies observed).}

\item{colgrad}{Vector of R specified colors defining the color gradient of
the heatmap.}

\item{nbreaks}{Number of discrete values along \code{"colgrad"}.}

\item{node.tag}{Specifies whether maximum likelihood estimators of ancestral
states are to be computed. Default is \code{TRUE}.}

\item{cexpt}{Size of color points at terminals and nodes.}

\item{link.lwd}{Line width for plotting, default to 1.}

\item{link.lty}{Line type. Coded as \code{lty} in
\code{\link[graphics:par]{par()}}.}

\item{fsize}{Relative font size for tip labels.}

\item{pts}{Logical value indicating whether or not to plot filled circles at
each vertex of the tree, as well as at transition points between
mapped states. Default is \code{FALSE}.}

\item{link.type}{If curved linking lines are desired, set to \code{"curved"}.
Default is \code{"straight"}.}

\item{ftype}{Font type. Options are \code{"reg"}, \code{"i"}
(italics), \code{"b"} (bold) or \code{"bi"} (bold-italics).}

\item{...}{Any graphical option admissible in
\code{\link[phytools:plot.cophylo]{phytools::plot.cophylo()}}}
}
\value{
A tanglegram with quantitative information displayed as heatmap.
}
\description{
Maps the estimated (in)congruence metrics of the individual host-symbiont
associations as heatmap on a tanglegram. It also plots the average frequency
(or residual/corrected frequency) of occurrence of each terminal
and optionally, the fast maximum likelihood estimators of ancestral states
of each node.
}
\section{NOTE}{

In order to calculate the ancestral states in the phylogenies, all
nodes of the trees (node.label) must have a value (NA or
empty values are not allowed). In addition, the trees must be
time-calibrated and preferably rooted. If one of these elements
is missing, an error will be generated and nodes and points of
terminals will be displayed as black.
}

\examples{
data(nuc_cp)
N = 10 #for the example, we recommend 1e+4 value
n = 8
NPc <- max_cong(np_matrix, NUCtr, CPtr, n, N, method = "paco",
                symmetric = TRUE, ei.correct = "sqrt.D",
                percentile = 0.01, res.fq = FALSE,
                strat = "parallel", cl = 4)
col = c("darkorchid4", "gold")
tangle_gram(NUCtr, CPtr, np_matrix, NPc, colscale = "sequential",
            colgrad = col, nbreaks = 50, node.tag = TRUE)


}
