% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prob_statistic.R
\name{prob_statistic}
\alias{prob_statistic}
\title{Frequencies of the associations for the posterior probability trees}
\usage{
prob_statistic(
  ths,
  HS,
  mTreeH,
  mTreeS,
  freqfun = "paco",
  fx,
  percentile = 0.01,
  correction = "none",
  symmetric = FALSE,
  ei.correct = "none",
  algm = "maxcong",
  proc.warns = FALSE,
  strat = "sequential",
  cl = 1
)
}
\arguments{
\item{ths}{List of trimmed matrices produced by
\code{\link[=trimHS_maxC]{trimHS_maxC()}} or
\code{\link[=trimHS_maxI]{trimHS_maxI()}}.}

\item{HS}{Host-Symbiont association matrix.}

\item{mTreeH}{Number of posterior-probability trees of host.}

\item{mTreeS}{Number of posterior-probability trees of symbiont.}

\item{freqfun}{The global-fit method to compute using the
posterior probability trees. Options are \code{"geoD"} (Geodesic
Distances), \code{"paco"} (PACo) or \code{"paraF"} (ParaFit).
It should be the same method used to obtain \code{"fx"}.}

\item{fx}{Vector of statistics produced with
\code{\link[=max_cong]{max_cong()}} or
\code{\link[=max_incong]{max_incong()}} for GD, PACo or
ParaFit.}

\item{percentile}{Percentile to evaluate (\emph{p}). Default is
\code{0.01} (1\\\%).}

\item{correction}{Correction to be assumed. The default value is
\code{"none"}. If \code{= "res.fq"}, a residual frequency value
(observed - expected frequency) is computed for each host-symbiont
association that maximizes phylogenetic congruence. If
\code{= "diff.fq"}, a corrected frequency value
(observed in p - observed in (p-1)) is computed for each
host-symbiont association.
It should be the same correction used to obtain \code{"fx"}.}

\item{symmetric}{Specifies the type of Procrustes superimposition. Default
is \code{FALSE}, indicates that the superposition is applied
asymmetrically (S depends on H). If \code{TRUE}, PACo is applied
symmetrically (dependency between S and H is reciprocal).}

\item{ei.correct}{Specifies how to correct potential negative eigenvalues
from the conversion of phylogenetic distances into Principal
Coordinates: \code{"none"} (the default) indicates that no correction
is applied, particularly if H and S are ultrametric; \code{"sqrt.D"}
takes the element-wise square-root of the phylogenetic distances;
\code{"lingoes"} and \code{"cailliez"} apply the classical Lingoes
and Cailliez corrections, respectively.}

\item{algm}{Only required if \code{correction = "none"}. Specifies the
algorithm that has been used to obtain
\code{"fx"} without correction. Use \code{= "maxcong"} for
\code{\link[=max_cong]{max_cong()}}, and \code{= "maxincong"} for
\code{\link[=max_incong]{max_incong()}}.}

\item{proc.warns}{Switches on/off trivial warnings returned when treeH and
treeS differ in size (number of tips). Default is \code{FALSE}.}

\item{strat}{Flag indicating whether execution is to be  \code{"sequential"}
or \code{"parallel"}. Default is \code{"sequential"},
resolves \R expressions sequentially in the current \R
process. If \code{"parallel"} resolves \R expressions in parallel in
separate \R sessions running in the background.}

\item{cl}{Number of cluster to be used for parallel computing.
\code{\link[parallelly:availableCores]{parallelly::availableCores()}}
returns the number of clusters available.
Default is \code{cl = 1} resulting in \code{"sequential"} execution.}
}
\value{
A matrix with the value of the statistics for each of the
probability trees.
}
\description{
Computes frequencies (or residual/corrected frequencies) of the
host-symbiont associations for pairs (H and S) of posterior  probability
trees from the statistics generatedwith \code{GD} (Geodesic Distances),
\code{PACo} (PACo) or \code{ParaFit}(ParaFit).
}
\examples{
\donttest{
data("nuc_cp")
N = 10 #for the example, we recommend 1e+4 value
n = 15
# Maximizing congruence (not run)
NPc <- max_cong(np_matrix, NUCtr, CPtr, n, N, method = "paco",
                symmetric = FALSE, ei.correct = "sqrt.D",
                percentile = 0.01, strat = "parallel", cl = 8)
THSc <- trimHS_maxC(N, np_matrix, n)
pp_treesPACOo_cong <- prob_statistic(THSc, np_matrix, NUC_500tr[1:10],
                         CP_500tr[1:10], freqfun = "paco", NPc,
                         percentile = 0.01, correction = "none",
                         algm = "maxcong", symmetric = FALSE,
                         ei.correct = "sqrt.D",
                         strat = "parallel", cl = 8)

# Maximizing incongruence
NPi <- max_incong(np_matrix, NUCtr, CPtr, n, N, method = "paco",
                  symmetric = FALSE, ei.correct = "sqrt.D",
                  percentile = 0.99, diff.fq = TRUE)
THSi <- trimHS_maxI(N, np_matrix, n)
pp_treesPACOo_incong <- prob_statistic(THSi, np_matrix, NUC_500tr[1:5],
                                 CP_500tr[1:5], freqfun = "paco", NPi,
                                 percentile = 0.99, correction = "diff.fq",
                                 symmetric = FALSE, ei.correct = "sqrt.D",
                                 strat = "parallel", cl = 8)
}

}
