% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_image.R
\name{get_image}
\alias{get_image}
\title{GET image}
\usage{
get_image(
  file_key,
  ids,
  scale = NULL,
  format = NULL,
  svg_include_id = NULL,
  svg_simplify_stroke = NULL,
  use_absolute_bounds = NULL,
  version = NULL
)
}
\arguments{
\item{file_key}{string. The key that a Figma file is referred by.}

\item{ids}{string. A comma separated list of node IDs to render}

\item{scale}{numeric. The image scaling factor is a number between 0.01 and
4}

\item{format}{string. A string enum for the image output format, can be
"jpg", "png", "svg", or "pdf"}

\item{svg_include_id}{logical. Whether or not to give each SVG element an
id attribute. Standard: \code{FALSE}}

\item{svg_simplify_stroke}{logical. Whether to simplify inside/outside
strokes and use stroke attribute if possible instead of mask element.
Default:  \code{TRUE}.}

\item{use_absolute_bounds}{logical. Whether the node is cropped or the area
around it is vacant, use the node's full dimensions. To export text nodes
without cropping, use this method. Standard: false.}

\item{version}{string. A specific version ID to use. Omitting this will use
the current version of the file}
}
\value{
S3 object of class \code{rigma_get_image}. Contains the parsed
JSON response with fields \code{err}, and \code{images}.
}
\description{
If there are no errors, "images" will be filled with a list of
node IDs and their corresponding URLs for the displayed images, and "status"
will be left empty. After 30 days, the picture assets will stop working.

It's important to note that the picture map could include null values. This
suggests that the node's attempt to render has failed. The lack of a node
id or other factors, such as the absence of renderable components, may be
responsible. Whether or not the render was successful, it is assured that
any node that was requested for rendering will be represented in this map.
}
\examples{
\dontshow{if (Sys.getenv("FIGMA_ACCESS_TOKEN") != "") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
#navigate to  file and get key from url
file_key <- "sFHgQh9dL6369o5wrZHmdR"
get_image(file_key, ids = "0:1", format = "svg")
}
\dontshow{\}) # examplesIf}
}
