% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotly_funts.R
\name{plotly_funts}
\alias{plotly_funts}
\title{Plot Functional Time Series (funts) with Plotly}
\usage{
plotly_funts(
  x,
  vars = NULL,
  types = NULL,
  subplot = TRUE,
  main = NULL,
  ylab = NULL,
  xlab = NULL,
  tlab = NULL,
  zlab = NULL,
  xticklabels = NULL,
  xticklocs = NULL,
  yticklabels = NULL,
  yticklocs = NULL,
  color_palette = "RdYlBu",
  reverse_color_palette = FALSE,
  ...
)
}
\arguments{
\item{x}{an object of class \code{\link{funts}}.}

\item{vars}{numeric vector specifying which variables in the FTS to plot (default: all).}

\item{types}{tuple of strings specifying plot types for each variable.}

\item{subplot}{logical for subplotting line plots.}

\item{main}{titles for each plot.}

\item{ylab}{y-axis titles.}

\item{xlab}{x-axis titles.}

\item{tlab}{time-axis titles.}

\item{zlab}{z-axis titles.}

\item{xticklabels}{tick labels for the domain of the functions.}

\item{xticklocs}{positions of tick labels for the domain of the functions.}

\item{yticklabels}{tick labels for the domain of the functions.}

\item{yticklocs}{positions of tick labels for the domain of the functions.}

\item{color_palette}{color palette for two-dimensional FTS plots.}

\item{reverse_color_palette}{reverse the color palette scale.}

\item{...}{additional arguments to pass to Plotly methods.}
}
\description{
Visualize univariate or multivariate Functional Time Series (funts) using Plotly-based plots.
}
\details{
Supported plot types for one-dimensional domain variables:
  - "line": line plots (default).
  - "heatmap": heatmaps.
  - "3Dsurface": 3D surface plots.
  - "3Dline": 3D line plots.

Supported plot type for two-dimensional domain variables:
  - "heatmap"

Each variable can be plotted multiple times with different types.
}
\examples{
\dontrun{
data("Callcenter") # Univariate FTS example

plotly_funts(Callcenter)

plotly_funts(Callcenter,
  main = "Call Center Data Line Plot",
  xticklabels = list(c("00:00", "06:00", "12:00", "18:00", "24:00")),
  xticklocs = list(c(1, 60, 120, 180, 240))
)

plotly_funts(Callcenter, type = "3Dline", main = "Callcenter Data")

plotly_funts(Callcenter, type = "3Dsurface", main = "Callcenter Data")

plotly_funts(Callcenter, type = "heatmap", main = "Callcenter Data")


data("Montana") # Multivariate FTS example
plotly_funts(Montana[1:100],
  main = c("Temperature Curves", "NDVI Images"),
  color_palette = "RdYlGn",
  xticklabels = list(
    c("00:00", "06:00", "12:00", "18:00", "24:00"),
    c("113.40\u00B0 W", "113.30\u00B0 W")
  ),
  xticklocs = list(c(1, 6, 12, 18, 24), c(1, 33)),
  yticklabels = list(NA, c("48.70\u00B0 N", "48.77\u00B0 N")),
  yticklocs = list(NA, c(1, 33))
)
}
}
\seealso{
\code{\link{funts}}, \code{\link{Callcenter}}, \code{\link{Montana}}
}
