% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marginal_transform.R
\name{margtransf.class}
\alias{margtransf.class}
\title{An S4 class to represent the Marginal Transformation}
\usage{
margtransf.class(data, qmarg, constrainedshape, parameters, thresh, dataexp)
}
\description{
An S4 class to represent the Marginal Transformation
}
\section{Slots}{

\describe{
\item{\code{data}}{A matrix containing the data on the original margins.}

\item{\code{qmarg}}{A vector containing the marginal quantile used to fit the Generalised Pareto Distribution (GPD) for each variable. Default is \code{rep(0.95, 2)}.}

\item{\code{constrainedshape}}{Logical. If \code{TRUE} (Default), the estimated shape parameter of the Generalised Pareto Distribution (GPD) is constrained to strictly above \code{-1}.}

\item{\code{parameters}}{A vector containing the scale and shape parameters of the Generalised Pareto Distribution (GPD).}

\item{\code{thresh}}{\loadmathjax{} A vector containing the threshold \mjeqn{u}{u} above which the Generalised Pareto Distribution (GPD) is fitted.}

\item{\code{dataexp}}{A matrix containing the data on standard exponential margins.}
}}

\keyword{internal}
