% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/T1EpSceptical.R
\name{T1EpSceptical}
\alias{T1EpSceptical}
\title{Compute overall type-I error rate of the sceptical p-value}
\usage{
T1EpSceptical(
  level,
  c,
  alternative = c("one.sided", "two.sided"),
  type = c("golden", "nominal", "controlled")
)
}
\arguments{
\item{level}{Threshold for the calibrated sceptical p-value.
Default is 0.025.}

\item{c}{Numeric vector of variance ratios of the original and replication
effect estimates. This is usually the ratio of the sample
size of the replication study to the sample size of the
original study.}

\item{alternative}{Specifies if \code{level}
is "two.sided" or "one.sided".}

\item{type}{Type of recalibration. Recalibration type can be either "golden"
(default), "nominal" (no recalibration), or "controlled".}
}
\value{
The overall type-I error rate.
}
\description{
The overall type-I error rate of the sceptical p-value is computed for a
specified level, the relative variance,
and the alternative hypothesis.
}
\details{
\code{T1EpSceptical} is the vectorized version of
the internal function \code{.T1EpSceptical_}.
\code{\link[base]{Vectorize}} is used to vectorize the function.
}
\examples{
## compare type-I error rate for different recalibration types
types <- c("nominal", "golden", "controlled")
c <- seq(0.2, 5, by = 0.05)
t1 <- sapply(X = types, FUN = function(t) {
  T1EpSceptical(type = t, c = c, alternative = "one.sided", level = 0.025)
})
matplot(
  x = c, y = t1*100, type = "l", lty = 1, lwd = 2, las = 1, log = "x",
  xlab = bquote(italic(c)), ylab = "Type-I error (\%)",
  xlim = c(0.2, 5)
)
legend("topright", legend = types, lty = 1, lwd = 2, col = seq_along(types))

}
\references{
Held, L. (2020). The harmonic mean chi-squared test to substantiate
scientific findings. \emph{Journal of the Royal Statistical Society: Series C
(Applied Statistics)}, \bold{69}, 697-708. \doi{10.1111/rssc.12410}

Held, L., Micheloud, C., Pawel, S. (2022). The assessment of replication
    success based on relative effect size. The Annals of Applied Statistics.
    16:706-720. \doi{10.1214/21-AOAS1502}

Micheloud, C., Balabdaoui, F., Held, L. (2023). Assessing replicability
with the sceptical p-value: Type-I error control and
sample size planning. \emph{Statistica Neerlandica}. \doi{10.1111/stan.12312}
}
\seealso{
\code{\link{pSceptical}}, \code{\link{levelSceptical}},
\code{\link{PPpSceptical}}
}
\author{
Leonhard Held, Samuel Pawel
}
