% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Electoral_index.R
\name{competitividad}
\alias{competitividad}
\title{Voting Dimension Index. Competitiveness (electoral and parliamentary).}
\usage{
competitividad(votes, seats)
}
\arguments{
\item{votes}{It is a vector of integers, containing the votes of all the candidates.}

\item{seats}{It is a vector of integers, containing the seats obtained by each of the candidates.}
}
\value{
Returns a dataframe, with the columns "electoral" and "parliamentary" to store the value of
the index of the competitiveness index in the electoral or the parliamentary way respectively.
}
\description{
This index will measure the level of electoral competition that exists in a given
party system between the first and second party that have obtained more votes in an specific election.
This indicator will therefore show how much rivalry there is between the two parties that
have received the most votes. To measure this phenomenon, the proximity or remoteness of the results
of these two political formations are used. This indicator is calculated using the following formula:

\deqn{competitiveness=1-(p_1-p_2)}{competitiveness=1-(p1-p2)}

Where p1 and p2 are the percentages of votes (or seats), as parts per unit, of the two most voted political
formations. A value close to 1 (p1=p2) indicates strong competitiveness, while a value of zero
(p1=1 p2=0) will indicate there is no competitiveness.
}
\examples{

competitividad(c(3947,3189,1971,466,345,82),c(184,99,44,10,1,0))

}
