% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Arco_parlamentario.R
\name{Arc_Parlamentario}
\alias{Arc_Parlamentario}
\title{Graphs. Representation of Parliamentary Arc}
\usage{
Arc_Parlamentario(
  Partidos,
  Escanos,
  cols = NULL,
  repr = c("absolute", "proportion"),
  titulo = "Enter a title here"
)
}
\arguments{
\item{Partidos}{It is a string vector containing the name of the parties.}

\item{Escanos}{It is a vector of natural numbers containing the seats that
have been allocated to each party.}

\item{cols}{(Optional) It is a vector containing the colors to be used to draw each zone
of the parliamentary arc.}

\item{repr}{It must contain the expression "absolute" or "Proportion" to perform the representation
based on absolute or relative terms respectively.}

\item{titulo}{To provide the title to be placed on the chart}
}
\value{
Returns a ggplot object, containing the representation of the obtained parliamentary arc.
}
\description{
This function facilitates the representation of the distribution of seats
obtained by each of the parties that have some parliamentary representation. It can be
introduced a title for the graph, the colors to be used for each party, as well as to choose
whether to make a distribution of seats in absolute or relative terms.
}
\examples{

bt <- data.frame(parties = c("PP", "CSU", "SPD", "AfD", "FDP", "UPyD", "CC", "Verdes"),
seats   = c(200, 46, 153, 92, 80, 69, 67, 2),
cols    = c("black", "blue", "red", "lightblue", "yellow", "purple", "lavenderblush", "grey"),
stringsAsFactors = FALSE)

Arc_Parlamentario(bt$parties, bt$seats, cols = bt$cols)

}
