#' Center of a cluster when the Relative distance is used.
#'
#' This function calculates the center of a group when the Relative distance is used to group.
#'
#' @param data Matrix. The points that we want to group are in the rows.
#' @param grouping List. List with the number of the rows of the data matrix that are in the group \code{[[i]]}.
#'
#'
#'@returns A matrix. The row i contains the centers of the group in \code{[[i]]}.
#'
#'@examples
#'set.seed(451)
#'data=rbind(matrix(runif(20,1,5), nrow = 2, ncol = 10),
#'           matrix(runif(20,20,30), nrow = 2, ncol = 10),
#'           matrix(runif(20,50,70), nrow = 2, ncol = 10))
#'
#'grouping=list(c(1,2), c(3,4),c(5,6))
#'centers_function_RelativeDistance(data, grouping)
#'
#'
#' @export





centers_function_RelativeDistance<-function(data, grouping){
  center=matrix(0,length(grouping), dim(data)[2])

  for (i in 1:(length(grouping))){

    if(length(grouping[[i]])==1){
      center[i,]=data[grouping[[i]],]
    }else{

      for(col in 1:dim(data)[2]){
        dj=rep(0, length(grouping[[i]]))
        for(j in 1:length(grouping[[i]])){
          reference=grouping[[i]][j]
          vect=grouping[[i]][-j]
          d_j_m=rep(0,length(vect) )
          for(m in 1:length(vect)){
            d_j_m[m]=RelativeDistance(data[reference,col], data[vect[m],col])
          }
          dj[j]=sum(d_j_m)
        }
        center[i,col]=data[grouping[[i]][which.min(dj)] , col]
      }

    }
  }
  return(center)
}
