% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_support_paral.R
\name{compute_support_paral}
\alias{compute_support_paral}
\title{Function to minimize to compute the function sigma for the projections of the identified set}
\usage{
compute_support_paral(
  dir_nb,
  sam0,
  Xnc,
  eps_default0,
  grid,
  dimXc,
  dimXnc,
  Xc_xb = NULL,
  Xncb,
  Xc_yb = NULL,
  Yb,
  values,
  weights_x,
  weights_y,
  constraint = NULL,
  c_sign,
  nc_sign,
  refs0,
  meth,
  T_xy,
  bc,
  version,
  R2bound = NULL,
  values_sel = NULL,
  ties = FALSE,
  modeNA = FALSE
)
}
\arguments{
\item{dir_nb}{the reference for the considered direction e in sam0}

\item{sam0}{the directions q to compute the radial function.}

\item{Xnc}{the noncommon regressor on the dataset  (Xnc,Xc). No default}

\item{eps_default0}{the matrix containing the directions q and the selected epsilon(q)}

\item{grid}{the number of points for the grid search on epsilon. Default is 30. If NULL, then epsilon is taken fixed equal to kp.}

\item{dimXc}{the dimension of the common regressors Xc.}

\item{dimXnc}{the dimension of the noncommon regressors Xnc.}

\item{Xc_xb}{the possibly bootstraped/subsampled common regressor on the dataset  (Xnc,Xc). Default is NULL.}

\item{Xncb}{the possibly bootstraped/subsampled noncommon regressor on the dataset (Xnc,Xc). No default.}

\item{Xc_yb}{the possibly bootstraped/subsampled common regressor on the dataset  (Y,Xc). Default is NULL.}

\item{Yb}{the possibly bootstraped/subsampled outcome variable  on the dataset  (Y,Xc). No default.}

\item{values}{the different unique points of support of the common regressor Xc.}

\item{weights_x}{the bootstrap or sampling weights for the dataset (Xnc,Xc).}

\item{weights_y}{the bootstrap or sampling weights for the dataset (Y,Xc).}

\item{constraint}{a vector indicating the different constraints in a vector of the size of X_c indicating the type of constraints, if any on f(X_c) : "concave", "concave", "nondecreasing", "nonincreasing", "nondecreasing_convex", "nondecreasing_concave",  "nonincreasing_convex", "nonincreasing_concave", or NULL for none. Default is NULL, no contraints at all.#' @param nc_sign if sign restrictions on the non-commonly observed regressors Xnc: -1 for a minus sign, 1 for a plus sign, 0 otherwise. Default is NULL, i.e. no constraints.}

\item{c_sign}{sign restrictions on the commonly observed regressors: -1 for a minus sign, 1 for a plus sign, 0 otherwise. Default is NULL, i.e. no constraints.}

\item{nc_sign}{sign restrictions on the non-commonly observed regressors Xnc: -1 for a minus sign, 1 for a plus sign, 0 otherwise. Default is NULL, i.e. no constraints.}

\item{refs0}{indicating the positions in the vector values corresponding to the components of betac.}

\item{meth}{the method for the choice of epsilon, either "adapt", i.e. adapted to the direction or "min" the minimum over the directions. Default is "adapt".}

\item{T_xy}{the apparent sample size the taking into account the difference in the two datasets.}

\item{bc}{if TRUE compute also the bounds on betac. Default is FALSE.}

\item{version}{version of the computation of the ratio, "first" indicates no weights, no ties, same sizes of the two datasets; "second" otherwise. Default is "second".}

\item{R2bound}{the lower bound on the R2 of the long regression if any. Default is NULL.}

\item{values_sel}{the selected values of Xc for the conditioning. Default is NULL.}

\item{ties}{Boolean indicating if there are ties in the dataset. Default is FALSE.}

\item{modeNA}{indicates if NA introduced if the interval is empty. Default is FALSE.}
}
\value{
the value of the support function in the specifed direction dir_nb.
}
\description{
Function to minimize to compute the function sigma for the projections of the identified set
}
