% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppXsimd.R
\name{supportsAVX512}
\alias{supportsAVX512}
\title{Determine if CPU supports AVX512 SIMD instructions}
\usage{
supportsAVX512()
}
\value{
Boolean
}
\description{
Determine if CPU supports AVX512 SIMD instructions
}
\examples{
\dontrun{

if (supportsAVX512()) {
  Sys.setenv(PKG_CPPFLAGS = getAVX512Flags())
  Rcpp::sourceCpp(verbose = TRUE, code='
    // [[Rcpp::plugins(cpp14)]]
    // [[Rcpp::depends(RcppXsimd)]]
               
    #include <Rcpp.h>
    #include "xsimd/xsimd.hpp"
               
    // [[Rcpp::export]] 
    void demoAVX512() {
      xsimd::batch<double, 8> a(1.0);
      xsimd::batch<double, 8> b(1.0);
      Rcpp::Rcout << a << " + " << b << " = " << (a + b) << std::endl;
    }')
  demoAVX512()
} else {
  message("AVX512 is not supported")
}
}
}
