% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cppXPtr.R
\name{cppXPtr}
\alias{cppXPtr}
\title{Define an \code{XPtr} with a C++ Implementation}
\usage{
cppXPtr(
  code,
  depends = character(),
  plugins = character(),
  includes = character(),
  rebuild = FALSE,
  cacheDir = getOption("rcpp.cache.dir", tempdir()),
  showOutput = verbose,
  verbose = getOption("verbose")
)
}
\arguments{
\item{code}{
    Source code for the function definition.
}

\item{depends}{
    Character vector of packages that the compilation depends on. Each package listed will first be queried for an \link[inline:plugins]{inline plugin} to determine header files to include. If no plugin is defined for the package then a header file based the package's name (e.g. \code{PkgName.h}) will be included.
}

\item{plugins}{
    Character vector of \link[inline:plugins]{inline plugins} to use for the compilation.
  }

\item{includes}{
    Character vector of user includes (inserted after the includes provided by \code{depends}).
}

\item{rebuild}{
    Force a rebuild of the shared library.
}

\item{cacheDir}{
    Directory to use for caching shared libraries. If the underlying code passed to \code{sourceCpp} has not changed since the last invocation then a cached version of the shared library is used. The default value of \code{tempdir()} results in the cache being valid only for the current R session. Pass an alternate directory to preserve the cache across R sessions.
}

\item{showOutput}{
    \code{TRUE} to print \code{R CMD SHLIB} output to the console.
}

\item{verbose}{
    \code{TRUE} to print detailed information about generated code to the console.
}
}
\value{
An object of class \code{XPtr} that points to the compiled function.
}
\description{
Dynamically define an \code{XPtr} with C++ source code. Compiles and links a shared
library with bindings to the C++ function using \code{\link[Rcpp]{cppFunction}},
then returns an \code{XPtr} that points to the function and can be used to be
plugged into another C++ backend.
}
\examples{
\donttest{
# takes time to compile
ptr <- cppXPtr("double foo(int a, double b) { return a + b; }")
class(ptr)
print(ptr)
}
}
\seealso{
\code{\link[Rcpp]{cppFunction}}, \code{\link{checkXPtr}}
}
