% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.r
\name{msgpack_write}
\alias{msgpack_write}
\alias{msgpackWrite}
\title{'MsgPack' write}
\usage{
msgpack_write(..., msg = NULL, file, mode = "auto")

msgpackWrite(..., msg = NULL, file, mode = "auto")
}
\arguments{
\item{...}{Serializable R objects.}

\item{msg}{Message to write to file.  If not NULL and a raw vector, write it instead of the R objects.  Default: NULL.}

\item{file}{A connection, or a string describing the file or pipe to write to, depending on the mode.}

\item{mode}{One of "auto", "file", "gzip" or "pipe".  If "auto", detects based on the file string (any space == pipe, ".gz" == gzip, file otherwise).  Ignored if file is a connection.}
}
\description{
A helper function to serialize an object and write it to a file, or a connection.
}
\examples{
tmp <- tempfile(fileext=".gz")
msgpack_write(1:10, file=tmp)
x <- msgpack_read(tmp, simplify=TRUE)
}
