% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desc_ei_per_grade.R
\name{desc_ei_per_grade}
\alias{desc_ei_per_grade}
\title{desc_ei_per_grade}
\usage{
desc_ei_per_grade(df_pat_grp, df_pat_grade, severity = TRUE, digits = 1)
}
\arguments{
\item{df_pat_grp}{A dataframe with two columns: USUBJID and RDGRPNAME (the RCT arm).}

\item{df_pat_grade}{A dataframe with four columns: USUBJID, EINUM (the AE id), EIGRDM (the AE grade) and EIGRAV (the AE severity which must be "Grave" and "Non grave").}

\item{severity}{A boolean to show severe adverse event line or not.}

\item{digits}{Number of digits for percentages}
}
\value{
A gt table summarizing the AE by grade.
}
\description{
A function to describe adverse events (AE) by grade.
}
\examples{
df_pat_grp <- data.frame(USUBJID = paste0("ID_", 1:10),
                         RDGRPNAME = c(rep("A", 3), rep("B", 3), rep("C", 4)))

df_pat_grade <- data.frame(USUBJID = c("ID_1", "ID_1",
                                      "ID_2",
                                      "ID_8",
                                      "ID_9"),
                           EINUM = c(1, 2,
                                      1,
                                      1,
                                      1),
                           EIGRDM = c(1, 3,
                                     4,
                                     2,
                                     4),
                           EIGRAV = c("Grave", "Non grave",
                                      "Non grave",
                                      "Non grave",
                                      "Grave"))

desc_ei_per_grade(df_pat_grp = df_pat_grp,
                  df_pat_grade = df_pat_grade)

}
