% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entropy_k_age.R
\name{entropy_k_age}
\alias{entropy_k_age}
\title{Calculate Keyfitz entropy for an age-based matrix population model}
\usage{
entropy_k_age(Umat)
}
\arguments{
\item{Umat}{A square numeric matrix representing the U submatrix of a matrix
population model. The dimension corresponds to the number of age classes}
}
\value{
Returns a single numeric value representing the Keyfitz entropy
for the given matrix. This value quantifies the dispersion of age at death.
}
\description{
Computes Keyfitz entropy from the U submatrix of an age-based matrix
population model.
}
\examples{
data(leslie_mpm1)

entropy_k_age(leslie_mpm1$matU)
}
\references{
Keyfitz, N. 1977. Applied Mathematical Demography. New York:
  Wiley.

  de Vries, C., Bernard, C., & Salguero-Gómez, R. 2023. Discretising
  Keyfitz' entropy for studies of actuarial senescence and comparative
  demography. Methods in Ecology and Evolution, 14, 1312–1319.
  <doi:10.1111/2041-210X.14083>
}
\seealso{
Other life history traits: 
\code{\link{entropy_d}()},
\code{\link{entropy_k}()},
\code{\link{entropy_k_stage}()},
\code{\link{gen_time}()},
\code{\link{life_elas}()},
\code{\link{life_expect_mean}()},
\code{\link{longevity}()},
\code{\link{net_repro_rate}()},
\code{\link{repro_maturity}},
\code{\link{shape_rep}()},
\code{\link{shape_surv}()}
}
\author{
Lotte de Vries <c.devries@uva.nl>

Owen Jones <jones@biology.sdu.dk>
}
\concept{life history traits}
