% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freedom_functions_1.R
\name{sep}
\alias{sep}
\title{Population sensitivity}
\usage{
sep(N = NA, n, pstar, se = 1, dig = 5)
}
\arguments{
\item{N}{population size, NA or vector of same length as n}

\item{n}{sample size (number tested), scalar or vector}

\item{pstar}{design prevalence as a proportion or integer, scalar
or vector of same length as n}

\item{se}{unit sensitivity, scalar or vector of same length as n}

\item{dig}{number of digits for rounding of results}
}
\value{
a vector of population-level sensitivities
}
\description{
Calculates population sensitivity using appropriate method,
  depending on whether or not N provided (hypergeometric if N provided,
  binomial otherwise), assuming perfect
  test specificity and representative sampling
}
\examples{
# examples for sep - checked
sep(n=300, pstar=0.01, se=1)
sep(NA, 300, 0.01, 1)
sep(10000, 150, 0.02, 1)
sep(n=1:100, pstar = 0.05, se=0.95)
N<- seq(30, 100, by = 5)
se<- 0.95
pstar<- 0.1
n<- rep(30, length(N))
sep(N, n, pstar, se = se)
sep(rep(100, 10), seq(10, 100, by = 10), pstar = 1, se=0.99)
N<- c(55, 134, NA, 44, 256)
n<- c(15, 30, 28, 15, 33)
sep(N, n, 0.1, 0.95)
}
\keyword{methods}
