% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/22_jalalidate_constructor.R
\name{JalaliDate}
\alias{JalaliDate}
\title{JalaliDate object constructor}
\usage{
JalaliDate(x, ...)
}
\arguments{
\item{x}{object (double, integer, Date, character, list)
list' argument could be named like JalaliDate(list(y=1375, m=1, d=2))}

\item{...}{... argument is used to pass options that overrides current options (see examples).}
}
\value{
JalaliDate object
}
\description{
Creates an instance of JalaliDate object by S3 system.
}
\details{
JalaliDate object is designed as 'base::Date' to handle Jalali (solar Hijri) date that is calendar of
Iran and Afghanistan. Like Date, the JalaliDate information is stored in the form of a 'double'
and is converted to another data type when necessary using the corresponding algorithm. The base day
(value = 0) is "1375/01/01". Calculation of leap year is like Microsoft .Net method (33 years cycles).
If the argument value is not valid at the time of conversion, it will be replaced with NA and a message
will be sent in this regard (see examples).
}
\examples{

JalaliDate(c(1, NA_real_, 2))
# [1] "1375/01/02" NA "1375/01/03"

JalaliDate(as.Date("2024-01-01"))
# [1] "1402/10/11"

JalaliDate(1.5)
# [1] "1375/01/02"

JalaliDate(c("1375/01/01", NA))
# [1] "1375/01/01" NA

# with warning
JalaliDate(c("1375/01/03", "1375/0201", ""))
# [1] "1375/01/03" NA NA
# Warning message:
#   NAs introduced by validation.

# year is out of default options range (1200-1500)
JalaliDate(list(9998,1,1))
# [1] NA
# Warning message:
#   NAs introduced by validation.

JalaliDate(c("1380/01/01", "9998/10/15"), MAX_YEAR=9999)
# [1] "1380/01/01" "9998/10/15"

tmp<- c("1375+01+01", "1390/02/02", "2000 02 02", "0100_02_02")
JalaliDate(tmp, VALID_SEPARATORS=c("+", "_", " ", "/"), MAX_YEAR=9999, MIN_YEAR = 0)
# [1] "1375/01/01" "1390/02/02" "2000/02/02" "0100/02/02"
}
