% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SsSampleSizeKGivenJ.R
\name{SsSampleSizeKGivenJ}
\alias{SsSampleSizeKGivenJ}
\title{Number of cases, for specified number of readers, to achieve desired power}
\usage{
SsSampleSizeKGivenJ(
  dataset,
  ...,
  J,
  FOM,
  effectSize = NULL,
  method = "OR",
  alpha = 0.05,
  desiredPower = 0.8,
  analysisOption = "RRRC",
  LegacyCode = FALSE
)
}
\arguments{
\item{dataset}{The \bold{pilot} dataset. If set to NULL 
then variance components must be supplied.}

\item{...}{Optional variance components, VarTR, VarTC and VarErr. These are
needed if dataset is not supplied.}

\item{J}{The number of readers in the \strong{pivotal} study.}

\item{FOM}{The figure of merit. Not needed if variance components are supplied.}

\item{effectSize}{The effect size to be used in the \strong{pivotal} study.
Default is NULL. Must be supplied if dataset is set to NULL and variance 
components are supplied.}

\item{method}{"OR" (default) or "DBM".}

\item{alpha}{The significance level of the study, default is 0.05.}

\item{desiredPower}{The desired statistical power, default is 0.8.}

\item{analysisOption}{Desired generalization, "RRRC", "FRRC", "RRFC" or "ALL" 
(the default).}

\item{LegacyCode}{Logical, default is \code{FALSE}, if \code{TRUE} the DBM
method is used. Otherwise the OR method is used.}
}
\value{
A list of two elements:

\item{K}{The minimum number of cases K in the pivotal study 
   to just achieve the desired statistical power, calculated 
   for each value of \code{analysisOption}.}

\item{power}{The predicted statistical power.}
}
\description{
Number of cases to achieve the desired power, for 
  specified number of readers J, and specified DBM or ORH analysis method
}
\details{
\code{effectSize} = NULL uses the \strong{observed} effect size in 
   the pilot study. A numeric value over-rides the default value. This 
   argument must be supplied if dataset = NULL and variance compenents 
   (the optional ... arguments) are supplied.
}
\note{
The procedure is valid for ROC studies only; for FROC studies see 
  Vignettes 19.
}
\examples{
## the following two should give identical results
SsSampleSizeKGivenJ(dataset02, FOM = "Wilcoxon", effectSize = 0.05, J = 6, method = "DBM")

a <- UtilVarComponentsDBM(dataset02, FOM = "Wilcoxon")$VarCom
SsSampleSizeKGivenJ(dataset = NULL, J = 6, effectSize = 0.05, method = "DBM", LegacyCode = TRUE,
   list(VarTR = a["VarTR",1], 
   VarTC = a["VarTC",1], 
   VarErr = a["VarErr",1]))

## the following two should give identical results
SsSampleSizeKGivenJ(dataset02, FOM = "Wilcoxon", effectSize = 0.05, J = 6, method = "OR")

a <- UtilORVarComponentsFactorial(dataset02, FOM = "Wilcoxon")$VarCom
KStar <- length(dataset02$ratings$NL[1,1,,1])
SsSampleSizeKGivenJ(dataset = NULL, J = 6, effectSize = 0.05, method = "OR", 
   list(KStar = KStar, 
   VarTR = a["VarTR",1], 
   Cov1 = a["Cov1",1], 
   Cov2 = a["Cov2",1], 
   Cov3 = a["Cov3",1], 
   Var = a["Var",1]))

\donttest{ 
for (J in 6:10) {
 ret <- SsSampleSizeKGivenJ(dataset02, FOM = "Wilcoxon", J = J, analysisOption = "RRRC") 
 message("# of readers = ", J, " estimated # of cases = ", ret$K, 
 ", predicted power = ", signif(ret$powerRRRC,3), "\n")
}
}

}
